/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.review.formatter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;
import org.jenkinsci.plugins.sonargerrit.review.formatter.IssueFormatter;
import org.jenkinsci.plugins.sonargerrit.review.formatter.TagFormatter;

public class CustomIssueFormatter
implements IssueFormatter,
TagFormatter<Tag> {
    private IssueAdapter issue;
    private String text;
    private String host;

    public CustomIssueFormatter(IssueAdapter issue, String text, String host) {
        this.issue = issue;
        this.host = host;
        this.text = text;
    }

    @Override
    public String getMessage() {
        String res = this.text;
        for (Tag tag : Tag.values()) {
            if (!res.contains(tag.getName())) continue;
            res = res.replace(tag.getName(), this.getValueToReplace(tag));
        }
        return res;
    }

    @Override
    public String getValueToReplace(Tag tag) {
        switch (tag) {
            case KEY: {
                return this.issue.getKey();
            }
            case COMPONENT: {
                return this.issue.getComponent();
            }
            case MESSAGE: {
                return this.issue.getMessage();
            }
            case SEVERITY: {
                return this.issue.getSeverity().name();
            }
            case RULE: {
                return this.issue.getRule();
            }
            case RULE_URL: {
                return this.getRuleLink(this.issue.getRule());
            }
            case STATUS: {
                return this.issue.getStatus();
            }
            case CREATION_DATE: {
                return this.issue.getCreationDate().toString();
            }
        }
        return null;
    }

    protected String getRuleLink(String rule) {
        if (this.host != null) {
            StringBuilder sb = new StringBuilder();
            String url = this.host.trim();
            if (!url.startsWith("http://") && !this.host.startsWith("https://")) {
                sb.append("http://");
            }
            sb.append(url);
            if (!url.endsWith("/")) {
                sb.append("/");
            }
            sb.append("coding_rules#rule_key=");
            sb.append(this.escapeHttp(rule));
            return sb.toString();
        }
        return rule;
    }

    protected String escapeHttp(String query) {
        try {
            return URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return query;
        }
    }

    public static enum Tag {
        KEY("<key>"),
        COMPONENT("<component>"),
        MESSAGE("<message>"),
        SEVERITY("<severity>"),
        RULE("<rule>"),
        RULE_URL("<rule_url>"),
        STATUS("<status>"),
        CREATION_DATE("<creation_date>");

        private final String name;

        private Tag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

