/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.integration;

import hudson.model.TaskListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.sonargerrit.TaskListenerLogger;
import org.jenkinsci.plugins.sonargerrit.filter.predicates.ByFilenameEndPredicate;
import org.jenkinsci.plugins.sonargerrit.inspection.InspectionReportAdapter;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;
import org.jenkinsci.plugins.sonargerrit.review.RevisionAdapter;

public class IssueAdapterProcessor {
    protected InspectionReportAdapter inspectionReport;
    protected RevisionAdapter revisionAdapter;
    protected Map<String, String> inspection2revisionFilepaths;
    private TaskListener listener;
    private static final Logger LOGGER = Logger.getLogger(IssueAdapterProcessor.class.getName());

    public IssueAdapterProcessor(TaskListener listener, InspectionReportAdapter inspectionReport, RevisionAdapter revisionAdapter) {
        this.listener = listener;
        this.inspectionReport = inspectionReport;
        this.revisionAdapter = revisionAdapter;
        this.inspection2revisionFilepaths = new HashMap<String, String>();
    }

    public void process() {
        Collection<IssueAdapter> issues = this.inspectionReport.getIssues();
        Set<String> changedFiles = this.revisionAdapter.getChangedFiles();
        for (IssueAdapter i : issues) {
            String reviewSystemFilePath = this.findReviewSystemFilepath(i, changedFiles);
            if (reviewSystemFilePath == null) continue;
            i.setFilepath(reviewSystemFilePath);
        }
    }

    protected String findReviewSystemFilepath(IssueAdapter i, Set<String> files) {
        String filepath = i.getFilepath();
        if (this.inspection2revisionFilepaths.containsKey(filepath)) {
            return this.inspection2revisionFilepaths.get(filepath);
        }
        if (files.contains(filepath)) {
            this.inspection2revisionFilepaths.put(filepath, filepath);
            return filepath;
        }
        String found = null;
        for (String s : files) {
            if (!this.namesMatch(i, s)) continue;
            if (found == null) {
                found = s;
                continue;
            }
            TaskListenerLogger.logMessage(this.listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.more.than.one.file.matched", i.getFilepath());
            return null;
        }
        return found;
    }

    protected boolean namesMatch(IssueAdapter issue, String reviewFilepath) {
        return ByFilenameEndPredicate.apply(reviewFilepath).apply(issue);
    }
}

