/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.inspection.converter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;

public class DateTypeConverter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static final Logger LOGGER = Logger.getLogger(DateTypeConverter.class.getName());

    public JsonElement serialize(Date src, Type srcType, JsonSerializationContext context) {
        return new JsonPrimitive(DateUtil.formatDate((Date)src));
    }

    public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
        String str = json.getAsString();
        try {
            return DateUtil.parseDate((String)str);
        }
        catch (DateParseException e) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssz");
                return df.parse(str);
            }
            catch (ParseException e1) {
                LOGGER.log(Level.WARNING, "An exception occurred on DateTypeConverter: {0}", e.getStackTrace());
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

