/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.sonargerrit.config.IssueFilterConfig;
import org.jenkinsci.plugins.sonargerrit.filter.predicates.ByChangedLinesPredicate;
import org.jenkinsci.plugins.sonargerrit.filter.predicates.ByFilenamesPredicate;
import org.jenkinsci.plugins.sonargerrit.filter.predicates.ByMinSeverityPredicate;
import org.jenkinsci.plugins.sonargerrit.filter.predicates.ByNewPredicate;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.Severity;

public class IssueFilter {
    private IssueFilterConfig filterConfig;
    private List<IssueAdapter> issues;
    private Map<String, Set<Integer>> changedLines;

    public IssueFilter(IssueFilterConfig filterConfig, List<IssueAdapter> issues, Map<String, Set<Integer>> changedLines) {
        this.filterConfig = filterConfig;
        this.issues = issues;
        this.changedLines = changedLines;
    }

    public Iterable<IssueAdapter> filter() {
        Severity severity;
        ArrayList<Object> toBeApplied = new ArrayList<Object>();
        if (this.filterConfig.isChangedLinesOnly()) {
            toBeApplied.add(ByChangedLinesPredicate.apply(this.changedLines));
        } else {
            toBeApplied.add(ByFilenamesPredicate.apply(this.changedLines.keySet()));
        }
        if (this.filterConfig.isNewIssuesOnly()) {
            toBeApplied.add(ByNewPredicate.apply(this.filterConfig.isNewIssuesOnly()));
        }
        if (!Severity.INFO.equals((Object)(severity = Severity.valueOf(this.filterConfig.getSeverity())))) {
            toBeApplied.add(ByMinSeverityPredicate.apply(severity));
        }
        return Iterables.filter(this.issues, (Predicate)Predicates.and(toBeApplied));
    }
}

