/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.config;

import com.google.common.base.MoreObjects;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.sonargerrit.SonarToGerritPublisher;
import org.jenkinsci.plugins.sonargerrit.util.DataHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class NotificationConfig
extends AbstractDescribableImpl<NotificationConfig> {
    @Nonnull
    private String noIssuesNotificationRecipient = DescriptorImpl.NOTIFICATION_RECIPIENT_NO_ISSUES.name();
    @Nonnull
    private String commentedIssuesNotificationRecipient = DescriptorImpl.NOTIFICATION_RECIPIENT_COMMENTED_ISSUES.name();
    @Nonnull
    private String negativeScoreNotificationRecipient = DescriptorImpl.NOTIFICATION_RECIPIENT_NEGATIVE_SCORE.name();

    public NotificationConfig(@Nonnull String noIssuesNotificationRecipient, @Nonnull String commentedIssuesNotificationRecipient, @Nonnull String negativeScoreNotificationRecipient) {
        this.setNoIssuesNotificationRecipient(noIssuesNotificationRecipient);
        this.setCommentedIssuesNotificationRecipient(commentedIssuesNotificationRecipient);
        this.setNegativeScoreNotificationRecipient(negativeScoreNotificationRecipient);
    }

    public NotificationConfig(@Nonnull NotifyHandling noIssuesNotificationRecipient, @Nonnull NotifyHandling commentedIssuesNotificationRecipient, @Nonnull NotifyHandling negativeScoreNotificationRecipient) {
        this(noIssuesNotificationRecipient.name(), commentedIssuesNotificationRecipient.name(), negativeScoreNotificationRecipient.name());
    }

    @DataBoundConstructor
    public NotificationConfig() {
        this(DescriptorImpl.NOTIFICATION_RECIPIENT_NO_ISSUES, DescriptorImpl.NOTIFICATION_RECIPIENT_COMMENTED_ISSUES, DescriptorImpl.NOTIFICATION_RECIPIENT_NEGATIVE_SCORE);
    }

    @Nonnull
    public String getNoIssuesNotificationRecipient() {
        return this.noIssuesNotificationRecipient;
    }

    @DataBoundSetter
    public void setNoIssuesNotificationRecipient(@Nonnull String noIssuesNotificationRecipient) {
        noIssuesNotificationRecipient = DataHelper.checkEnumValueCorrect(NotifyHandling.class, noIssuesNotificationRecipient);
        this.noIssuesNotificationRecipient = (String)MoreObjects.firstNonNull((Object)noIssuesNotificationRecipient, (Object)DescriptorImpl.NOTIFICATION_RECIPIENT_NO_ISSUES_STR);
    }

    @Nonnull
    public String getCommentedIssuesNotificationRecipient() {
        return this.commentedIssuesNotificationRecipient;
    }

    @DataBoundSetter
    public void setCommentedIssuesNotificationRecipient(@Nonnull String commentedIssuesNotificationRecipient) {
        commentedIssuesNotificationRecipient = DataHelper.checkEnumValueCorrect(NotifyHandling.class, commentedIssuesNotificationRecipient);
        this.commentedIssuesNotificationRecipient = (String)MoreObjects.firstNonNull((Object)commentedIssuesNotificationRecipient, (Object)DescriptorImpl.NOTIFICATION_RECIPIENT_COMMENTED_ISSUES_STR);
    }

    @Nonnull
    public String getNegativeScoreNotificationRecipient() {
        return this.negativeScoreNotificationRecipient;
    }

    @DataBoundSetter
    public void setNegativeScoreNotificationRecipient(@Nonnull String negativeScoreNotificationRecipient) {
        negativeScoreNotificationRecipient = DataHelper.checkEnumValueCorrect(NotifyHandling.class, negativeScoreNotificationRecipient);
        this.negativeScoreNotificationRecipient = (String)MoreObjects.firstNonNull((Object)negativeScoreNotificationRecipient, (Object)DescriptorImpl.NOTIFICATION_RECIPIENT_NEGATIVE_SCORE_STR);
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<NotificationConfig> {
        public static final NotifyHandling NOTIFICATION_RECIPIENT_NO_ISSUES = SonarToGerritPublisher.DescriptorImpl.NOTIFICATION_RECIPIENT_NO_ISSUES;
        public static final NotifyHandling NOTIFICATION_RECIPIENT_COMMENTED_ISSUES = SonarToGerritPublisher.DescriptorImpl.NOTIFICATION_RECIPIENT_SOME_ISSUES;
        public static final NotifyHandling NOTIFICATION_RECIPIENT_NEGATIVE_SCORE = SonarToGerritPublisher.DescriptorImpl.NOTIFICATION_RECIPIENT_NEGATIVE_SCORE;
        public static final String NOTIFICATION_RECIPIENT_NO_ISSUES_STR = NOTIFICATION_RECIPIENT_NO_ISSUES.name();
        public static final String NOTIFICATION_RECIPIENT_COMMENTED_ISSUES_STR = NOTIFICATION_RECIPIENT_COMMENTED_ISSUES.name();
        public static final String NOTIFICATION_RECIPIENT_NEGATIVE_SCORE_STR = NOTIFICATION_RECIPIENT_NEGATIVE_SCORE.name();

        public FormValidation doCheckNoIssuesNotificationRecipient(@QueryParameter String value) {
            return this.checkNotificationType(value);
        }

        public FormValidation doCheckCommentedIssuesNotificationRecipient(@QueryParameter String value) {
            return this.checkNotificationType(value);
        }

        public FormValidation doCheckNegativeScoreNotificationRecipient(@QueryParameter String value) {
            return this.checkNotificationType(value);
        }

        private FormValidation checkNotificationType(@QueryParameter String value) {
            if (value == null || NotifyHandling.valueOf((String)value) == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.review.notification.recipient.unknown"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "NotificationConfig";
        }
    }
}

