/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.config;

import com.google.common.base.MoreObjects;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.jenkinsci.plugins.sonargerrit.SonarToGerritPublisher;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.Severity;
import org.jenkinsci.plugins.sonargerrit.util.DataHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class IssueFilterConfig
extends AbstractDescribableImpl<IssueFilterConfig> {
    private String severity;
    private boolean newIssuesOnly;
    private boolean changedLinesOnly;

    public IssueFilterConfig(String severity, boolean newIssuesOnly, boolean changedLinesOnly) {
        this.setSeverity(severity);
        this.setNewIssuesOnly(newIssuesOnly);
        this.setChangedLinesOnly(changedLinesOnly);
    }

    @DataBoundConstructor
    public IssueFilterConfig() {
        this(DescriptorImpl.SEVERITY, false, false);
    }

    public String getSeverity() {
        return this.severity;
    }

    public boolean isChangedLinesOnly() {
        return this.changedLinesOnly;
    }

    public boolean isNewIssuesOnly() {
        return this.newIssuesOnly;
    }

    @DataBoundSetter
    public void setSeverity(String severity) {
        severity = DataHelper.checkEnumValueCorrect(Severity.class, severity);
        this.severity = (String)MoreObjects.firstNonNull((Object)severity, (Object)DescriptorImpl.SEVERITY);
    }

    @DataBoundSetter
    public void setNewIssuesOnly(boolean newIssuesOnly) {
        this.newIssuesOnly = newIssuesOnly;
    }

    @DataBoundSetter
    public void setChangedLinesOnly(boolean changedLinesOnly) {
        this.changedLinesOnly = changedLinesOnly;
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<IssueFilterConfig> {
        public static final String SEVERITY = SonarToGerritPublisher.DescriptorImpl.SEVERITY;
        public static final boolean NEW_ISSUES_ONLY = false;
        public static final boolean CHANGED_LINES_ONLY = false;

        public FormValidation doCheckSeverity(@QueryParameter String value) {
            if (value == null || Severity.valueOf(value) == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.review.filter.severity.unknown"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "IssueFilterConfig";
        }
    }
}

