/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.sonargerrit.TaskListenerLogger;
import org.jenkinsci.plugins.sonargerrit.config.GerritAuthenticationConfig;
import org.jenkinsci.plugins.sonargerrit.config.InspectionConfig;
import org.jenkinsci.plugins.sonargerrit.config.IssueFilterConfig;
import org.jenkinsci.plugins.sonargerrit.config.NotificationConfig;
import org.jenkinsci.plugins.sonargerrit.config.ReviewConfig;
import org.jenkinsci.plugins.sonargerrit.config.ScoreConfig;
import org.jenkinsci.plugins.sonargerrit.config.SubJobConfig;
import org.jenkinsci.plugins.sonargerrit.filter.IssueFilter;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.Severity;
import org.jenkinsci.plugins.sonargerrit.inspection.sonarqube.SonarConnector;
import org.jenkinsci.plugins.sonargerrit.integration.IssueAdapterProcessor;
import org.jenkinsci.plugins.sonargerrit.review.GerritConnectionInfo;
import org.jenkinsci.plugins.sonargerrit.review.GerritConnector;
import org.jenkinsci.plugins.sonargerrit.review.GerritReviewBuilder;
import org.jenkinsci.plugins.sonargerrit.review.GerritRevisionWrapper;
import org.jenkinsci.plugins.sonargerrit.util.BackCompatibilityHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SonarToGerritPublisher
extends Publisher
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(SonarToGerritPublisher.class.getName());
    public static final String GERRIT_CHANGE_NUMBER_ENV_VAR_NAME = "GERRIT_CHANGE_NUMBER";
    public static final String GERRIT_NAME_ENV_VAR_NAME = "GERRIT_NAME";
    public static final String GERRIT_PATCHSET_NUMBER_ENV_VAR_NAME = "GERRIT_PATCHSET_NUMBER";
    @Nonnull
    private InspectionConfig inspectionConfig = new InspectionConfig();
    @Nonnull
    private NotificationConfig notificationConfig = new NotificationConfig();
    @Nonnull
    private ReviewConfig reviewConfig = new ReviewConfig();
    private ScoreConfig scoreConfig = null;
    private GerritAuthenticationConfig authConfig = null;
    private BackCompatibilityHelper backCompatibilityHelper = new BackCompatibilityHelper(this);

    @DataBoundConstructor
    public SonarToGerritPublisher() {
    }

    @Deprecated
    public SonarToGerritPublisher(String sonarURL, List<SubJobConfig> subJobConfigs, String severity, boolean changedLinesOnly, boolean newIssuesOnly, String noIssuesToPostText, String someIssuesToPostText, String issueComment, boolean overrideCredentials, String httpUsername, String httpPassword, boolean postScore, String category, String noIssuesScore, String issuesScore, String noIssuesNotification, String issuesNotification) {
        this.setSonarURL(sonarURL);
        this.setSubJobConfigs(subJobConfigs);
        if (overrideCredentials) {
            this.setAuthConfig(new GerritAuthenticationConfig(httpUsername, httpPassword));
        }
        IssueFilterConfig issueFilterConfig = new IssueFilterConfig(severity, newIssuesOnly, changedLinesOnly);
        ReviewConfig reviewConfig = new ReviewConfig(issueFilterConfig, noIssuesToPostText, someIssuesToPostText, issueComment);
        this.setReviewConfig(reviewConfig);
        if (postScore) {
            ScoreConfig scoreConfig = new ScoreConfig(issueFilterConfig, category, Integer.parseInt(noIssuesScore), Integer.parseInt(issuesScore));
            this.setScoreConfig(scoreConfig);
        } else {
            this.setScoreConfig(null);
        }
        NotificationConfig notificationConfig = new NotificationConfig(noIssuesNotification, issuesNotification, issuesNotification);
        this.setNotificationConfig(notificationConfig);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        SonarConnector sonarConnector = new SonarConnector(listener, this.inspectionConfig);
        sonarConnector.readSonarReports(filePath);
        GerritTrigger trigger = GerritTrigger.getTrigger((Job)run.getParent());
        Map<String, String> envVars = this.getEnvVars(run, listener, GerritConnectionInfo.REQUIRED_VARS);
        GerritConnectionInfo connectionInfo = new GerritConnectionInfo(envVars, trigger, this.authConfig);
        try {
            boolean postScore;
            GerritConnector connector = new GerritConnector(connectionInfo);
            connector.connect();
            GerritRevisionWrapper revisionInfo = new GerritRevisionWrapper(connector.getRevision());
            revisionInfo.loadData();
            Map<String, Set<Integer>> fileToChangedLines = revisionInfo.getFileToChangedLines();
            if (this.inspectionConfig.isPathCorrectionNeeded()) {
                new IssueAdapterProcessor(listener, sonarConnector, revisionInfo).process();
            }
            Multimap<String, IssueAdapter> file2issuesToComment = this.getFilteredFileToIssueMultimap(this.reviewConfig.getIssueFilterConfig(), sonarConnector, fileToChangedLines);
            TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.issues.to.comment", file2issuesToComment.entries().size());
            Multimap<String, IssueAdapter> file2issuesToScore = null;
            boolean bl = postScore = this.scoreConfig != null;
            if (postScore) {
                file2issuesToScore = this.getFilteredFileToIssueMultimap(this.scoreConfig.getIssueFilterConfig(), sonarConnector, fileToChangedLines);
                TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.issues.to.score", file2issuesToScore.entries().size());
            }
            ReviewInput reviewInput = new GerritReviewBuilder(file2issuesToComment, file2issuesToScore, this.reviewConfig, this.scoreConfig, this.notificationConfig, this.inspectionConfig).buildReview();
            revisionInfo.sendReview(reviewInput);
            TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.review.sent", new Object[0]);
        }
        catch (RestApiException e) {
            LOGGER.log(Level.SEVERE, "Unable to post review: " + e.getMessage(), e);
            throw new AbortException("Unable to post review: " + e.getMessage());
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            throw new AbortException(e.getMessage());
        }
    }

    private Multimap<String, IssueAdapter> getFilteredFileToIssueMultimap(IssueFilterConfig filterConfig, SonarConnector sonarConnector, Map<String, Set<Integer>> fileToChangedLines) {
        IssueFilter commentFilter = new IssueFilter(filterConfig, (List<IssueAdapter>)sonarConnector.getIssues(), fileToChangedLines);
        Iterable<IssueAdapter> issuesToComment = commentFilter.filter();
        return sonarConnector.getReportData(issuesToComment);
    }

    private Map<String, String> getEnvVars(Run<?, ?> run, TaskListener listener, List<String> varNames) throws IOException, InterruptedException {
        HashMap<String, String> envVars = new HashMap<String, String>();
        for (String varName : varNames) {
            envVars.put(varName, this.getEnvVar(run, listener, varName));
        }
        return envVars;
    }

    private String getEnvVar(Run<?, ?> run, TaskListener listener, String name) throws IOException, InterruptedException {
        Object parameterValue;
        ParameterValue parameter;
        ParametersAction action;
        EnvVars envVars = run.getEnvironment(listener);
        String value = (String)envVars.get((Object)name);
        if (value == null && (action = (ParametersAction)run.getAction(ParametersAction.class)) != null && (parameter = action.getParameter(name)) != null && (parameterValue = parameter.getValue()) != null) {
            value = parameterValue.toString();
        }
        return value;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Nonnull
    public InspectionConfig getInspectionConfig() {
        return this.inspectionConfig;
    }

    @Nonnull
    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    @Nonnull
    public ReviewConfig getReviewConfig() {
        return this.reviewConfig;
    }

    public ScoreConfig getScoreConfig() {
        return this.scoreConfig;
    }

    public GerritAuthenticationConfig getAuthConfig() {
        return this.authConfig;
    }

    @DataBoundSetter
    public void setInspectionConfig(@Nonnull InspectionConfig inspectionConfig) {
        this.inspectionConfig = (InspectionConfig)((Object)MoreObjects.firstNonNull((Object)((Object)inspectionConfig), (Object)((Object)new InspectionConfig())));
    }

    @DataBoundSetter
    public void setNotificationConfig(@Nonnull NotificationConfig notificationConfig) {
        this.notificationConfig = (NotificationConfig)((Object)MoreObjects.firstNonNull((Object)((Object)notificationConfig), (Object)((Object)new NotificationConfig())));
    }

    @DataBoundSetter
    public void setReviewConfig(@Nonnull ReviewConfig reviewConfig) {
        this.reviewConfig = (ReviewConfig)((Object)MoreObjects.firstNonNull((Object)((Object)reviewConfig), (Object)((Object)new ReviewConfig())));
    }

    @DataBoundSetter
    public void setScoreConfig(ScoreConfig scoreConfig) {
        this.scoreConfig = scoreConfig;
    }

    @DataBoundSetter
    public void setAuthConfig(GerritAuthenticationConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Deprecated
    @DataBoundSetter
    public void setSonarURL(String sonarURL) {
        this.backCompatibilityHelper.setSonarURL(sonarURL);
    }

    @Deprecated
    @DataBoundSetter
    public void setSubJobConfigs(List<SubJobConfig> subJobConfigs) {
        this.backCompatibilityHelper.setSubJobConfigs(subJobConfigs);
    }

    @Deprecated
    @DataBoundSetter
    public void setSeverity(String severity) {
        this.backCompatibilityHelper.setSeverity(severity);
    }

    @Deprecated
    @DataBoundSetter
    public void setNewIssuesOnly(boolean newIssuesOnly) {
        this.backCompatibilityHelper.setNewIssuesOnly(newIssuesOnly);
    }

    @Deprecated
    @DataBoundSetter
    public void setChangedLinesOnly(boolean changedLinesOnly) {
        this.backCompatibilityHelper.setChangedLinesOnly(changedLinesOnly);
    }

    @Deprecated
    @DataBoundSetter
    public void setNoIssuesToPostText(String noIssuesToPost) {
        this.backCompatibilityHelper.setNoIssuesToPostText(noIssuesToPost);
    }

    @Deprecated
    @DataBoundSetter
    public void setSomeIssuesToPostText(String someIssuesToPost) {
        this.backCompatibilityHelper.setSomeIssuesToPostText(someIssuesToPost);
    }

    @Deprecated
    @DataBoundSetter
    public void setIssueComment(String issueComment) {
        this.backCompatibilityHelper.setIssueComment(issueComment);
    }

    @Deprecated
    @DataBoundSetter
    public void setOverrideCredentials(boolean overrideCredentials) {
        this.backCompatibilityHelper.setOverrideCredentials(overrideCredentials);
    }

    @Deprecated
    @DataBoundSetter
    public void setHttpUsername(String overrideHttpUsername) {
        this.backCompatibilityHelper.setHttpUsername(overrideHttpUsername);
    }

    @Deprecated
    @DataBoundSetter
    public void setHttpPassword(String overrideHttpPassword) {
        this.backCompatibilityHelper.setHttpPassword(overrideHttpPassword);
    }

    @Deprecated
    @DataBoundSetter
    public void setPostScore(boolean postScore) {
        this.backCompatibilityHelper.setPostScore(postScore);
    }

    @Deprecated
    @DataBoundSetter
    public void setCategory(String category) {
        this.backCompatibilityHelper.setCategory(category);
    }

    @Deprecated
    @DataBoundSetter
    public void setNoIssuesScore(String score) {
        this.backCompatibilityHelper.setNoIssuesScore(score);
    }

    @Deprecated
    @DataBoundSetter
    public void setIssuesScore(String score) {
        this.backCompatibilityHelper.setIssuesScore(score);
    }

    @Deprecated
    @DataBoundSetter
    public void setNoIssuesNotification(String notification) {
        this.backCompatibilityHelper.setNoIssuesNotification(notification);
    }

    @Deprecated
    @DataBoundSetter
    public void setIssuesNotification(String notification) {
        this.backCompatibilityHelper.setIssuesNotification(notification);
    }

    @Deprecated
    @DataBoundSetter
    public void setProjectPath(String path) {
        this.backCompatibilityHelper.setProjectPath(path);
    }

    @Deprecated
    @DataBoundSetter
    public void setPath(String path) {
        this.backCompatibilityHelper.setPath(path);
    }

    @Deprecated
    public String getSonarURL() {
        return this.backCompatibilityHelper.getSonarURL();
    }

    @Deprecated
    public Collection<SubJobConfig> getSubJobConfigs() {
        return this.backCompatibilityHelper.getSubJobConfigs();
    }

    @Deprecated
    public String getSeverity() {
        return this.backCompatibilityHelper.getSeverity();
    }

    @Deprecated
    public boolean isNewIssuesOnly() {
        return this.backCompatibilityHelper.isNewIssuesOnly();
    }

    @Deprecated
    public boolean isChangedLinesOnly() {
        return this.backCompatibilityHelper.isChangedLinesOnly();
    }

    @Deprecated
    public String getNoIssuesToPostText() {
        return this.backCompatibilityHelper.getNoIssuesToPostText();
    }

    @Deprecated
    public String getSomeIssuesToPostText() {
        return this.backCompatibilityHelper.getSomeIssuesToPostText();
    }

    @Deprecated
    public String getIssueComment() {
        return this.backCompatibilityHelper.getIssueComment();
    }

    @Deprecated
    public boolean isOverrideCredentials() {
        return this.backCompatibilityHelper.isOverrideCredentials();
    }

    @Deprecated
    public String getHttpUsername() {
        return this.backCompatibilityHelper.getHttpUsername();
    }

    @Deprecated
    public String getHttpPassword() {
        return this.backCompatibilityHelper.getHttpPassword();
    }

    @Deprecated
    public boolean isPostScore() {
        return this.backCompatibilityHelper.isPostScore();
    }

    @Deprecated
    public String getCategory() {
        return this.backCompatibilityHelper.getCategory();
    }

    @Deprecated
    public String getNoIssuesScore() {
        return this.backCompatibilityHelper.getNoIssuesScore();
    }

    @Deprecated
    public String getIssuesScore() {
        return this.backCompatibilityHelper.getIssuesScore();
    }

    @Deprecated
    public String getNoIssuesNotification() {
        return this.backCompatibilityHelper.getNoIssuesNotification();
    }

    @Deprecated
    public String getIssuesNotification() {
        return this.backCompatibilityHelper.getIssuesNotification();
    }

    @Deprecated
    public String getProjectPath() {
        return this.backCompatibilityHelper.getProjectPath();
    }

    @Deprecated
    public String getPath() {
        return this.backCompatibilityHelper.getPath();
    }

    @Symbol(value={"sonarToGerrit"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final NotifyHandling NOTIFICATION_RECIPIENT_NO_ISSUES = NotifyHandling.NONE;
        public static final NotifyHandling NOTIFICATION_RECIPIENT_SOME_ISSUES = NotifyHandling.OWNER;
        public static final NotifyHandling NOTIFICATION_RECIPIENT_NEGATIVE_SCORE = NotifyHandling.OWNER;
        public static final String PROJECT_PATH = "";
        public static final String SONAR_REPORT_PATH = "target/sonar/sonar-report.json";
        public static final String SONAR_URL = "http://localhost:9000";
        public static final String DEFAULT_INSPECTION_CONFIG_TYPE = "base";
        public static final boolean AUTO_MATCH_INSPECTION_AND_REVISION_PATHS = false;
        public static final String NO_ISSUES_TEXT = Localization.getLocalized("jenkins.plugin.default.review.title.no.issues");
        public static final String SOME_ISSUES_TEXT = Localization.getLocalized("jenkins.plugin.default.review.title.issues");
        public static final String ISSUE_COMMENT_TEXT = Localization.getLocalized("jenkins.plugin.default.review.body");
        public static final String CATEGORY = "Code-Review";
        public static final Integer NO_ISSUES_SCORE = 1;
        public static final Integer SOME_ISSUES_SCORE = -1;
        public static final boolean OVERRIDE_CREDENTIALS = false;
        public static final String SEVERITY = Severity.INFO.name();
        public static final boolean NEW_ISSUES_ONLY = false;
        public static final boolean CHANGED_LINES_ONLY = false;
        public static final int DEFAULT_SCORE = 0;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Localization.getLocalized("jenkins.plugin.build.step.name");
        }
    }
}

