/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.util;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jenkinsci.plugins.sonargerrit.SonarToGerritPublisher;
import org.jenkinsci.plugins.sonargerrit.config.AuthenticationConfig;
import org.jenkinsci.plugins.sonargerrit.config.GerritAuthenticationConfig;
import org.jenkinsci.plugins.sonargerrit.config.InspectionConfig;
import org.jenkinsci.plugins.sonargerrit.config.IssueFilterConfig;
import org.jenkinsci.plugins.sonargerrit.config.NotificationConfig;
import org.jenkinsci.plugins.sonargerrit.config.ReviewConfig;
import org.jenkinsci.plugins.sonargerrit.config.ScoreConfig;
import org.jenkinsci.plugins.sonargerrit.config.SubJobConfig;

public final class BackCompatibilityHelper {
    private SonarToGerritPublisher publisher;
    private ScoreConfig tempScoreConfig;
    private GerritAuthenticationConfig tempAuthConfig;

    public BackCompatibilityHelper(SonarToGerritPublisher publisher) {
        this.publisher = publisher;
        this.tempScoreConfig = new ScoreConfig();
        this.tempAuthConfig = new GerritAuthenticationConfig();
    }

    public void setSonarURL(String sonarURL) {
        InspectionConfig inspectionConfig = this.getOrCreateInspectionConfig();
        inspectionConfig.setServerURL(sonarURL);
    }

    public void setProjectPath(String path) {
        InspectionConfig inspectionConfig = this.getOrCreateInspectionConfig();
        if (inspectionConfig.getBaseConfig() == null) {
            inspectionConfig.setBaseConfig(new SubJobConfig());
        }
        inspectionConfig.getBaseConfig().setProjectPath(path);
    }

    public void setPath(String path) {
        InspectionConfig inspectionConfig = this.getOrCreateInspectionConfig();
        if (inspectionConfig.getBaseConfig() == null) {
            inspectionConfig.setBaseConfig(new SubJobConfig());
        }
        inspectionConfig.getBaseConfig().setSonarReportPath(path);
    }

    public void setSubJobConfigs(List<SubJobConfig> subJobConfigs) {
        InspectionConfig inspectionConfig = this.getOrCreateInspectionConfig();
        if (subJobConfigs == null || subJobConfigs.size() == 0) {
            inspectionConfig.setBaseConfig(new SubJobConfig());
            inspectionConfig.setSubJobConfigs(new LinkedList<SubJobConfig>());
        } else if (subJobConfigs.size() == 1) {
            inspectionConfig.setBaseConfig(subJobConfigs.get(0));
            inspectionConfig.setSubJobConfigs(new LinkedList<SubJobConfig>());
        } else {
            inspectionConfig.setBaseConfig(null);
            inspectionConfig.setSubJobConfigs(subJobConfigs);
        }
    }

    public void setPostScore(Boolean postScore) {
        if (postScore.booleanValue()) {
            if (this.getScoreConfig() == null) {
                this.publisher.setScoreConfig(this.tempScoreConfig);
            }
        } else {
            this.publisher.setScoreConfig(null);
        }
    }

    public void setCategory(String category) {
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        scoreConfig.setCategory(category);
    }

    public void setNoIssuesScore(String score) {
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        try {
            scoreConfig.setNoIssuesScore(Integer.parseInt(score));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setIssuesScore(String score) {
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        try {
            scoreConfig.setIssuesScore(Integer.parseInt(score));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setSeverity(String severity) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        IssueFilterConfig reviewFilterConfig = reviewConfig.getIssueFilterConfig();
        reviewFilterConfig.setSeverity(severity);
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        IssueFilterConfig scoreFilterConfig = scoreConfig.getIssueFilterConfig();
        scoreFilterConfig.setSeverity(severity);
    }

    public void setNewIssuesOnly(Boolean changedLinesOnly) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        IssueFilterConfig reviewFilterConfig = reviewConfig.getIssueFilterConfig();
        reviewFilterConfig.setNewIssuesOnly(changedLinesOnly);
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        IssueFilterConfig scoreFilterConfig = scoreConfig.getIssueFilterConfig();
        scoreFilterConfig.setNewIssuesOnly(changedLinesOnly);
    }

    public void setChangedLinesOnly(Boolean changedLinesOnly) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        IssueFilterConfig reviewFilterConfig = reviewConfig.getIssueFilterConfig();
        reviewFilterConfig.setChangedLinesOnly(changedLinesOnly);
        ScoreConfig scoreConfig = this.getOrCreateScoreConfig();
        IssueFilterConfig scoreFilterConfig = scoreConfig.getIssueFilterConfig();
        scoreFilterConfig.setChangedLinesOnly(changedLinesOnly);
    }

    public void setNoIssuesToPostText(String noIssuesToPost) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        reviewConfig.setNoIssuesTitleTemplate(noIssuesToPost);
    }

    public void setSomeIssuesToPostText(String someIssuesToPost) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        reviewConfig.setSomeIssuesTitleTemplate(someIssuesToPost);
    }

    public void setIssueComment(String issueComment) {
        ReviewConfig reviewConfig = this.getOrCreateReviewConfig();
        reviewConfig.setIssueCommentTemplate(issueComment);
    }

    public void setOverrideCredentials(Boolean overrideCredentials) {
        if (overrideCredentials.booleanValue()) {
            if (this.getAuthConfig() == null) {
                this.publisher.setAuthConfig(this.tempAuthConfig);
            }
        } else {
            this.publisher.setAuthConfig(null);
        }
    }

    public void setHttpUsername(String overrideHttpUsername) {
        GerritAuthenticationConfig config = this.getOrCreateAuthenticationConfig();
        ((AuthenticationConfig)config).setUsername(overrideHttpUsername);
    }

    public void setHttpPassword(String overrideHttpPassword) {
        GerritAuthenticationConfig config = this.getOrCreateAuthenticationConfig();
        ((AuthenticationConfig)config).setPassword(overrideHttpPassword);
    }

    public void setNoIssuesNotification(String notification) {
        NotificationConfig notificationConfig = this.getOrCreateNotificationConfig();
        notificationConfig.setNoIssuesNotificationRecipient(notification);
    }

    public void setIssuesNotification(String notification) {
        NotificationConfig notificationConfig = this.getOrCreateNotificationConfig();
        notificationConfig.setCommentedIssuesNotificationRecipient(notification);
    }

    private InspectionConfig getOrCreateInspectionConfig() {
        return this.getInspectionConfig();
    }

    private ReviewConfig getOrCreateReviewConfig() {
        return this.getReviewConfig();
    }

    private NotificationConfig getOrCreateNotificationConfig() {
        return this.getNotificationConfig();
    }

    protected ScoreConfig getOrCreateScoreConfig() {
        return (ScoreConfig)((Object)MoreObjects.firstNonNull((Object)((Object)this.getScoreConfig()), (Object)((Object)this.tempScoreConfig)));
    }

    private GerritAuthenticationConfig getOrCreateAuthenticationConfig() {
        return (GerritAuthenticationConfig)((Object)MoreObjects.firstNonNull((Object)((Object)this.getAuthConfig()), (Object)((Object)this.tempAuthConfig)));
    }

    public String getSonarURL() {
        return this.getNull(String.class);
    }

    public Collection<SubJobConfig> getSubJobConfigs() {
        return this.getNull(Collection.class);
    }

    public String getSeverity() {
        return this.getNull(String.class);
    }

    public boolean isNewIssuesOnly() {
        return this.getNull();
    }

    public boolean isChangedLinesOnly() {
        return this.getNull();
    }

    public String getNoIssuesToPostText() {
        return this.getNull(String.class);
    }

    public String getSomeIssuesToPostText() {
        return this.getNull(String.class);
    }

    public String getIssueComment() {
        return this.getNull(String.class);
    }

    public boolean isOverrideCredentials() {
        return this.getNull();
    }

    public String getHttpUsername() {
        return this.getNull(String.class);
    }

    public String getHttpPassword() {
        return this.getNull(String.class);
    }

    public boolean isPostScore() {
        return this.getNull();
    }

    public String getCategory() {
        return this.getNull(String.class);
    }

    public String getNoIssuesScore() {
        return this.getNull(String.class);
    }

    public String getIssuesScore() {
        return this.getNull(String.class);
    }

    public String getNoIssuesNotification() {
        return this.getNull(String.class);
    }

    public String getIssuesNotification() {
        return this.getNull(String.class);
    }

    public String getProjectPath() {
        return this.getNull(String.class);
    }

    public String getPath() {
        return this.getNull(String.class);
    }

    private <V> V getNull(Class<V> clazz) {
        return null;
    }

    private boolean getNull() {
        return false;
    }

    private InspectionConfig getInspectionConfig() {
        return this.publisher.getInspectionConfig();
    }

    private ReviewConfig getReviewConfig() {
        return this.publisher.getReviewConfig();
    }

    private ScoreConfig getScoreConfig() {
        return this.publisher.getScoreConfig();
    }

    private NotificationConfig getNotificationConfig() {
        return this.publisher.getNotificationConfig();
    }

    private GerritAuthenticationConfig getAuthConfig() {
        return this.publisher.getAuthConfig();
    }
}

