/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.review;

import com.google.common.base.MoreObjects;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.sonargerrit.config.AuthenticationConfig;
import org.jenkinsci.plugins.sonargerrit.review.ConnectionInfo;
import org.jenkinsci.plugins.sonargerrit.util.DataHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;

public class GerritConnectionInfo
implements ConnectionInfo {
    public static final String GERRIT_NAME_ENV_VAR_NAME = "GERRIT_NAME";
    public static final String GERRIT_CHANGE_NUMBER_ENV_VAR_NAME = "GERRIT_CHANGE_NUMBER";
    public static final String GERRIT_PATCHSET_NUMBER_ENV_VAR_NAME = "GERRIT_PATCHSET_NUMBER";
    public static final List<String> REQUIRED_VARS = Collections.unmodifiableList(Arrays.asList("GERRIT_NAME", "GERRIT_CHANGE_NUMBER", "GERRIT_PATCHSET_NUMBER"));
    private final String serverName;
    private final String changeNumber;
    private final String patchsetNumber;
    private final String username;
    private final String password;

    public GerritConnectionInfo(Map<String, String> envVars, GerritTrigger trigger, AuthenticationConfig authenticationConfig) {
        this.serverName = this.retrieveServerName(envVars, trigger);
        this.changeNumber = this.retrieveChangeNumber(envVars);
        this.patchsetNumber = this.retrievePatchsetNumber(envVars);
        this.username = authenticationConfig != null ? authenticationConfig.getUsername() : null;
        this.password = authenticationConfig != null ? authenticationConfig.getPassword() : null;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public String getPatchsetNumber() {
        return this.patchsetNumber;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private String retrieveServerName(Map<String, String> envVars, GerritTrigger trigger) {
        String serverName = envVars.get(GERRIT_NAME_ENV_VAR_NAME);
        String triggerServerName = trigger != null ? trigger.getServerName() : null;
        serverName = (String)MoreObjects.firstNonNull((Object)serverName, (Object)triggerServerName);
        this.checkServerName(serverName);
        return serverName;
    }

    private String retrieveChangeNumber(Map<String, String> envVars) {
        String changeNum = envVars.get(GERRIT_CHANGE_NUMBER_ENV_VAR_NAME);
        DataHelper.checkNotEmpty(changeNum, Localization.getLocalized("jenkins.plugin.error.gerrit.change.number.empty"));
        Integer changeNumber = DataHelper.parseNumber(changeNum);
        DataHelper.checkNotEmpty(changeNumber, Localization.getLocalized("jenkins.plugin.error.gerrit.change.number.format"));
        return changeNum;
    }

    private String retrievePatchsetNumber(Map<String, String> envVars) {
        String patchsetNum = envVars.get(GERRIT_PATCHSET_NUMBER_ENV_VAR_NAME);
        DataHelper.checkNotEmpty(patchsetNum, Localization.getLocalized("jenkins.plugin.error.gerrit.patchset.number.empty"));
        Integer patchsetNumber = DataHelper.parseNumber(patchsetNum);
        DataHelper.checkNotEmpty(patchsetNumber, Localization.getLocalized("jenkins.plugin.error.gerrit.patchset.number.format"));
        return patchsetNum;
    }

    private void checkServerName(String serverName) {
        DataHelper.checkNotEmpty(serverName, Localization.getLocalized("jenkins.plugin.error.gerrit.server.empty"));
    }
}

