/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.ready.jenkins;

import com.smartbear.ready.jenkins.JUnitReportPublisher;
import com.smartbear.ready.jenkins.ParameterContainer;
import com.smartbear.ready.jenkins.PrintableReportPublisher;
import com.smartbear.ready.jenkins.ProcessRunner;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JenkinsSoapUIProTestRunner
extends Builder
implements SimpleBuildStep {
    private String pathToTestrunner;
    private String pathToProjectFile;
    private String testSuite;
    private String testCase;
    private String testSuiteTags;
    private String testCaseTags;
    private Secret projectPassword;
    private String environment;

    @DataBoundConstructor
    public JenkinsSoapUIProTestRunner(String pathToTestrunner, String pathToProjectFile) {
        this.pathToTestrunner = pathToTestrunner;
        this.pathToProjectFile = pathToProjectFile;
    }

    public String getPathToTestrunner() {
        return this.pathToTestrunner;
    }

    public String getPathToProjectFile() {
        return this.pathToProjectFile;
    }

    public String getTestSuite() {
        return this.testSuite;
    }

    @DataBoundSetter
    public void setTestSuite(String testSuite) {
        this.testSuite = testSuite;
    }

    public String getTestCase() {
        return this.testCase;
    }

    @DataBoundSetter
    public void setTestCase(String testCase) {
        this.testCase = testCase;
    }

    public String getTestSuiteTags() {
        return this.testSuiteTags;
    }

    @DataBoundSetter
    public void setTestSuiteTags(String tags) {
        this.testSuiteTags = tags;
    }

    public String getTestCaseTags() {
        return this.testCaseTags;
    }

    @DataBoundSetter
    public void setTestCaseTags(String tags) {
        this.testCaseTags = tags;
    }

    public String getProjectPassword() {
        return Secret.toString((Secret)this.projectPassword);
    }

    @DataBoundSetter
    public void setProjectPassword(String projectPassword) {
        this.projectPassword = Secret.fromString((String)projectPassword);
    }

    public String getEnvironment() {
        return this.environment;
    }

    @DataBoundSetter
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Proc process = null;
        ProcessRunner processRunner = new ProcessRunner();
        PrintStream out = listener.getLogger();
        try {
            boolean published;
            process = processRunner.run(new ParameterContainer.Builder().withPathToTestrunner(this.pathToTestrunner).withPathToProjectFile(this.pathToProjectFile).withTestSuite(this.testSuite).withTestCase(this.testCase).withTestSuiteTags(this.testSuiteTags).withTestCaseTags(this.testCaseTags).withProjectPassword(this.getProjectPassword()).withEnvironment(this.environment).withWorkspace(workspace).build(), run, launcher, listener);
            if (process == null) {
                throw new AbortException("Could not start SoapUI Pro functional testing.");
            }
            if (process.join() != 0) {
                run.setResult(Result.FAILURE);
            }
            if (processRunner.isReportCreated() && !(published = new JUnitReportPublisher().publish(run, listener, launcher, processRunner.getReportsFolderPath()))) {
                out.println("JUnit-style report was not published!");
            }
            if (processRunner.isPrintableReportCreated()) {
                File printableReportFileOnMaster;
                String printableReportName = processRunner.getPrintableReportName();
                FilePath printableReportFileOnSlave = new FilePath(launcher.getChannel(), processRunner.getReportsFolderPath() + processRunner.getPrintableReportPath() + printableReportName);
                if (this.copyReportToBuildDir(printableReportFileOnSlave, new FilePath(printableReportFileOnMaster = new File(run.getRootDir().getAbsolutePath() + File.separator + printableReportName)), listener)) {
                    boolean printableReportPublished = new PrintableReportPublisher().publish(run, printableReportFileOnMaster, listener);
                    if (printableReportPublished) {
                        this.addPrintableReportLinkToConsoleOutput(out, run, printableReportName);
                    } else {
                        out.println("Printable report was not published!");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
            throw new AbortException("Could not start SoapUI Pro functional testing.");
        }
        finally {
            if (process != null) {
                process.kill();
            }
        }
    }

    private boolean copyReportToBuildDir(FilePath fromFile, FilePath toFile, TaskListener listener) {
        try {
            if (fromFile.exists()) {
                toFile.copyFrom(fromFile);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
        }
        return false;
    }

    private void addPrintableReportLinkToConsoleOutput(PrintStream out, Run<?, ?> run, String printableReportName) {
        String printableReportLink = "/" + run.getUrl() + "soapui-pro-functional-testing" + "/dynamic/" + printableReportName;
        out.println(ModelHyperlinkNote.encodeTo((String)printableReportLink, (String)"Click here to view detailed report"));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"SoapUIPro"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckPathToTestrunner(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please, set path to testrunner");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPathToProjectFile(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please, set path to the SoapUI Pro project");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestSuite(@QueryParameter String value, @QueryParameter String testCase) {
            if (value.length() == 0 && testCase.length() != 0) {
                return FormValidation.error((String)"Please, enter a test suite for the specified test case");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "SoapUI Pro: Run Functional Test";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

