/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.workflow;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.Messages;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.StandardSlackService;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SlackSendStep
extends AbstractStepImpl {
    @Nonnull
    private final String message;
    private String color;
    private String token;
    private String tokenCredentialId;
    private boolean botUser;
    private String channel;
    private String baseUrl;
    private String teamDomain;
    private boolean failOnError;
    private String attachments;

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    public String getColor() {
        return this.color;
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = Util.fixEmpty((String)color);
    }

    public String getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = Util.fixEmpty((String)token);
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = Util.fixEmpty((String)tokenCredentialId);
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    @DataBoundSetter
    public void setBotUser(boolean botUser) {
        this.botUser = botUser;
    }

    public String getChannel() {
        return this.channel;
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = Util.fixEmpty((String)channel);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = Util.fixEmpty((String)baseUrl);
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    @DataBoundSetter
    public void setTeamDomain(String teamDomain) {
        this.teamDomain = Util.fixEmpty((String)teamDomain);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @DataBoundSetter
    public void setAttachments(String attachments) {
        this.attachments = attachments;
    }

    public String getAttachments() {
        return this.attachments;
    }

    @DataBoundConstructor
    public SlackSendStep(@Nonnull String message) {
        this.message = message;
    }

    public static class SlackSendStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        transient SlackSendStep step;
        @StepContextParameter
        transient TaskListener listener;

        protected Void run() throws Exception {
            boolean publishSuccess;
            boolean botUser;
            String token;
            String tokenCredentialId;
            Jenkins jenkins;
            try {
                jenkins = Jenkins.getInstance();
            }
            catch (NullPointerException ne) {
                this.listener.error(Messages.NotificationFailedWithException(ne));
                return null;
            }
            SlackNotifier.DescriptorImpl slackDesc = (SlackNotifier.DescriptorImpl)jenkins.getDescriptorByType(SlackNotifier.DescriptorImpl.class);
            this.listener.getLogger().println("run slackstepsend, step " + this.step.token + ":" + this.step.botUser + ", desc " + slackDesc.getToken() + ":" + slackDesc.getBotUser());
            String baseUrl = this.step.baseUrl != null ? this.step.baseUrl : slackDesc.getBaseUrl();
            String team = this.step.teamDomain != null ? this.step.teamDomain : slackDesc.getTeamDomain();
            String string = tokenCredentialId = this.step.tokenCredentialId != null ? this.step.tokenCredentialId : slackDesc.getTokenCredentialId();
            if (this.step.token != null) {
                token = this.step.token;
                botUser = this.step.botUser;
            } else {
                token = slackDesc.getToken();
                botUser = slackDesc.getBotUser();
            }
            String channel = this.step.channel != null ? this.step.channel : slackDesc.getRoom();
            String color = this.step.color != null ? this.step.color : "";
            this.listener.getLogger().println(Messages.SlackSendStepConfig(this.step.baseUrl == null, this.step.teamDomain == null, this.step.token == null, this.step.channel == null, this.step.color == null));
            SlackService slackService = this.getSlackService(baseUrl, team, token, tokenCredentialId, botUser, channel);
            if (this.step.attachments != null) {
                JsonSlurper jsonSlurper = new JsonSlurper();
                JSON json = null;
                try {
                    json = jsonSlurper.parseText(this.step.attachments);
                }
                catch (JSONException e) {
                    this.listener.error(Messages.NotificationFailedWithException((Object)e));
                    return null;
                }
                if (!(json instanceof JSONArray)) {
                    this.listener.error(Messages.NotificationFailedWithException(new IllegalArgumentException("Attachments must be JSONArray")));
                    return null;
                }
                JSONArray jsonArray = (JSONArray)json;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonNode;
                    Object object = jsonArray.get(i);
                    if (!(object instanceof JSONObject) || (jsonNode = (JSONObject)object).has("fallback")) continue;
                    jsonNode.put("fallback", (Object)this.step.message);
                }
                publishSuccess = slackService.publish(jsonArray, color);
            } else {
                publishSuccess = slackService.publish(this.step.message, color);
            }
            if (!publishSuccess && this.step.failOnError) {
                throw new AbortException(Messages.NotificationFailed());
            }
            if (!publishSuccess) {
                this.listener.error(Messages.NotificationFailed());
            }
            return null;
        }

        SlackService getSlackService(String baseUrl, String team, String token, String tokenCredentialId, boolean botUser, String channel) {
            return new StandardSlackService(baseUrl, team, token, tokenCredentialId, botUser, channel);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(SlackSendStepExecution.class);
        }

        public String getFunctionName() {
            return "slackSend";
        }

        public String getDisplayName() {
            return Messages.SlackSendStepDisplayName();
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Project project) {
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new HostnameRequirement("*.slack.com")}));
        }

        public FormValidation doCheckToken(@QueryParameter String value) {
            return FormValidation.warning((String)"Exposing your Integration Token is a security risk. Please use the Integration Token Credential ID");
        }
    }
}

