/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.webhook;

import hudson.model.Cause;
import hudson.model.Project;
import hudson.security.ACL;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.webhook.RouterCommand;
import jenkins.plugins.slack.webhook.SlackRouterCommand;
import jenkins.plugins.slack.webhook.model.SlackPostData;
import jenkins.plugins.slack.webhook.model.SlackTextMessage;
import jenkins.plugins.slack.webhook.model.SlackWebhookCause;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public class ScheduleJobCommand
extends SlackRouterCommand
implements RouterCommand<SlackTextMessage> {
    public ScheduleJobCommand(SlackPostData data) {
        super(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SlackTextMessage execute(String ... args) {
        String projectName = args[0];
        SecurityContext ctx = ACL.impersonate((Authentication)ACL.SYSTEM);
        String response = "";
        Project project = (Project)Jenkins.getInstance().getItemByFullName(projectName, Project.class);
        try {
            if (project == null) {
                SlackTextMessage slackTextMessage = new SlackTextMessage("Could not find project (" + projectName + ")\n");
                return slackTextMessage;
            }
            if (project.scheduleBuild((Cause)new SlackWebhookCause(this.getData().getUser_name()))) {
                SlackTextMessage slackTextMessage = new SlackTextMessage("Build scheduled for project " + projectName + "\n");
                return slackTextMessage;
            }
            SlackTextMessage slackTextMessage = new SlackTextMessage("Build not scheduled due to an issue with Jenkins");
            return slackTextMessage;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)ctx);
        }
    }
}

