/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.webhook;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.security.ACL;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.webhook.RouterCommand;
import jenkins.plugins.slack.webhook.SlackRouterCommand;
import jenkins.plugins.slack.webhook.model.SlackPostData;
import jenkins.plugins.slack.webhook.model.SlackTextMessage;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public class ListProjectsCommand
extends SlackRouterCommand
implements RouterCommand<SlackTextMessage> {
    public ListProjectsCommand(SlackPostData data) {
        super(data);
    }

    @Override
    public SlackTextMessage execute(String ... args) {
        SecurityContext ctx = ACL.impersonate((Authentication)ACL.SYSTEM);
        String response = "*Projects:*\n";
        List jobs = Jenkins.getInstance().getAllItems(AbstractProject.class);
        SecurityContextHolder.setContext((SecurityContext)ctx);
        for (AbstractProject job : jobs) {
            if (!job.isBuildable()) continue;
            AbstractBuild lastBuild = job.getLastBuild();
            String buildNumber = "TBD";
            String status = "TBD";
            if (lastBuild != null) {
                Result result;
                buildNumber = Integer.toString(lastBuild.getNumber());
                if (lastBuild.isBuilding()) {
                    status = "BUILDING";
                }
                if ((result = lastBuild.getResult()) != null) {
                    status = result.toString();
                }
            }
            if (jobs.size() <= 10) {
                response = response + ">*" + job.getDisplayName() + "*\n>*Last Build:* #" + buildNumber + "\n>*Status:* " + status;
                response = response + "\n\n\n";
                continue;
            }
            response = response + ">*" + job.getDisplayName() + "* :: *Last Build:* #" + buildNumber + " :: *Status:* " + status;
            response = response + "\n\n";
        }
        if (jobs == null || jobs.size() == 0) {
            response = response + ">_No projects found_";
        }
        return new SlackTextMessage(response);
    }
}

