/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.webhook;

import hudson.model.AbstractBuild;
import hudson.model.Project;
import hudson.security.ACL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.webhook.RouterCommand;
import jenkins.plugins.slack.webhook.SlackRouterCommand;
import jenkins.plugins.slack.webhook.model.SlackPostData;
import jenkins.plugins.slack.webhook.model.SlackTextMessage;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public class GetProjectLogCommand
extends SlackRouterCommand
implements RouterCommand<SlackTextMessage> {
    public GetProjectLogCommand(SlackPostData data) {
        super(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SlackTextMessage execute(String ... args) {
        String projectName = args[0];
        String buildNumber = args[1];
        SecurityContext ctx = ACL.impersonate((Authentication)ACL.SYSTEM);
        List log = new ArrayList();
        try {
            Project project = (Project)Jenkins.getInstance().getItemByFullName(projectName, Project.class);
            if (project == null) {
                SlackTextMessage slackTextMessage = new SlackTextMessage("Could not find project (" + projectName + ")\n");
                return slackTextMessage;
            }
            AbstractBuild build = project.getBuildByNumber(Integer.parseInt(buildNumber));
            if (build == null) {
                SlackTextMessage slackTextMessage = new SlackTextMessage("Could not find build #" + buildNumber + " for (" + projectName + ")\n");
                return slackTextMessage;
            }
            log = build.getLog(25);
        }
        catch (IOException ex) {
            SlackTextMessage slackTextMessage = new SlackTextMessage("Error occured returning log: " + ex.getMessage());
            return slackTextMessage;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)ctx);
        }
        String response = "*" + projectName + "* *#" + buildNumber + "*\n";
        response = response + "```";
        for (String line : log) {
            response = response + line + "\n";
        }
        response = response + "```";
        return new SlackTextMessage(response);
    }
}

