/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.config;

import hudson.model.Job;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.slack.SlackNotifier;

public class JobConfigMigrator {
    private static final Logger logger = Logger.getLogger(JobConfigMigrator.class.getName());

    public void migrate(Job<?, ?> job) {
        logger.info(String.format("Migrating job \"%s\" with type %s", job.getName(), job.getClass().getName()));
        SlackNotifier.SlackJobProperty slackJobProperty = (SlackNotifier.SlackJobProperty)job.getProperty(SlackNotifier.SlackJobProperty.class);
        if (slackJobProperty == null) {
            logger.finest(String.format("Configuration is already up to date for \"%s\", skipping migration", job.getName()));
            return;
        }
        try {
            job.removeProperty(SlackNotifier.SlackJobProperty.class);
            job.save();
            logger.info(String.format("Configuration for \"%s\" updated successfully", job.getName()));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

