/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.config;

import hudson.model.AbstractProject;
import hudson.model.Item;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.slack.config.AbstractProjectConfigMigrator;
import org.springframework.util.ReflectionUtils;

public class ItemWithTemplateConfigMigrator {
    private static final Logger logger = Logger.getLogger(ItemWithTemplateConfigMigrator.class.getName());
    private AbstractProjectConfigMigrator projectMigrator;

    public ItemWithTemplateConfigMigrator(AbstractProjectConfigMigrator projectMigrator) {
        this.projectMigrator = projectMigrator;
    }

    public boolean migrate(Item item) {
        AbstractProject<?, ?> project = this.getTemplateProject(item);
        if (project != null) {
            this.projectMigrator.migrate(project);
            return true;
        }
        return false;
    }

    private AbstractProject<?, ?> getTemplateProject(Item item) {
        logger.log(Level.FINE, String.format("Checking \"%s\" for AbstractProject template", item.getName()));
        Method getTemplate = ReflectionUtils.findMethod(item.getClass(), (String)"getTemplate");
        if (getTemplate == null) {
            logger.log(Level.FINE, "No template getter method found");
            return null;
        }
        Object obj = null;
        try {
            obj = getTemplate.invoke((Object)item, new Object[0]);
        }
        catch (Exception e) {
            logger.info("Error getting \"template\" value: " + e.getMessage());
            return null;
        }
        if (obj == null) {
            logger.log(Level.FINE, "Item has no template");
        } else {
            if (obj instanceof AbstractProject) {
                return (AbstractProject)obj;
            }
            logger.log(Level.FINE, "Template is not an AbstractProject; type is: " + obj.getClass().getName());
        }
        return null;
    }
}

