/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.config;

import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.util.DescribableList;
import java.lang.reflect.Method;
import jenkins.plugins.slack.config.AbstractProjectConfigMigrator;
import jenkins.plugins.slack.config.ItemWithTemplateConfigMigrator;
import jenkins.plugins.slack.config.JobConfigMigrator;
import org.springframework.util.ReflectionUtils;

public class ItemConfigMigrator {
    private final AbstractProjectConfigMigrator projectMigrator;
    private final JobConfigMigrator jobMigrator;
    private final ItemWithTemplateConfigMigrator templateMigrator;

    public ItemConfigMigrator() {
        this.projectMigrator = new AbstractProjectConfigMigrator();
        this.jobMigrator = new JobConfigMigrator();
        this.templateMigrator = new ItemWithTemplateConfigMigrator(this.projectMigrator);
    }

    protected ItemConfigMigrator(AbstractProjectConfigMigrator projectMigrator, JobConfigMigrator jobMigrator, ItemWithTemplateConfigMigrator templateMigrator) {
        this.projectMigrator = projectMigrator;
        this.jobMigrator = jobMigrator;
        this.templateMigrator = templateMigrator;
    }

    public boolean migrate(Item item) {
        return this.migrateAbstractProject(item) || this.migrateJobWithoutPublishersList(item) || this.templateMigrator.migrate(item);
    }

    private boolean migrateAbstractProject(Item item) {
        if (item instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)item;
            this.projectMigrator.migrate(project);
            return true;
        }
        return false;
    }

    private boolean migrateJobWithoutPublishersList(Item item) {
        if (item instanceof Job && !this.hasMethodGetPublishersList(item)) {
            Job job = (Job)item;
            this.jobMigrator.migrate(job);
            return true;
        }
        return false;
    }

    private boolean hasMethodGetPublishersList(Item item) {
        Method method = ReflectionUtils.findMethod(item.getClass(), (String)"getPublishersList");
        return method != null && method.getReturnType().equals(DescribableList.class);
    }
}

