/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.config;

import hudson.model.AbstractProject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.slack.CommitInfoChoice;
import jenkins.plugins.slack.SlackNotifier;
import org.apache.commons.lang.StringUtils;

public class AbstractProjectConfigMigrator {
    private static final Logger logger = Logger.getLogger(AbstractProjectConfigMigrator.class.getName());

    public void migrate(AbstractProject<?, ?> project) {
        logger.info(String.format("Migrating project \"%s\" with type %s", project.getName(), project.getClass().getName()));
        SlackNotifier.SlackJobProperty slackJobProperty = (SlackNotifier.SlackJobProperty)project.getProperty(SlackNotifier.SlackJobProperty.class);
        if (slackJobProperty == null) {
            logger.finest(String.format("Configuration is already up to date for \"%s\", skipping migration", project.getName()));
            return;
        }
        SlackNotifier slackNotifier = (SlackNotifier)project.getPublishersList().get(SlackNotifier.class);
        if (slackNotifier == null) {
            logger.info(String.format("Configuration does not have a notifier for \"%s\", not migrating settings", project.getName()));
        } else {
            this.updateSlackNotifier(slackNotifier, slackJobProperty);
        }
        try {
            project.removeProperty(SlackNotifier.SlackJobProperty.class);
            project.save();
            logger.info("Configuration updated successfully");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void updateSlackNotifier(SlackNotifier slackNotifier, SlackNotifier.SlackJobProperty slackJobProperty) {
        if (StringUtils.isBlank((String)slackNotifier.getTeamDomain())) {
            slackNotifier.setTeamDomain(slackJobProperty.getTeamDomain());
        }
        if (StringUtils.isBlank((String)slackNotifier.getAuthToken())) {
            slackNotifier.setAuthToken(slackJobProperty.getToken());
        }
        if (StringUtils.isBlank((String)slackNotifier.getRoom())) {
            slackNotifier.setRoom(slackJobProperty.getRoom());
        }
        slackNotifier.setStartNotification(slackJobProperty.getStartNotification());
        slackNotifier.setNotifyAborted(slackJobProperty.getNotifyAborted());
        slackNotifier.setNotifyFailure(slackJobProperty.getNotifyFailure());
        slackNotifier.setNotifyNotBuilt(slackJobProperty.getNotifyNotBuilt());
        slackNotifier.setNotifySuccess(slackJobProperty.getNotifySuccess());
        slackNotifier.setNotifyUnstable(slackJobProperty.getNotifyUnstable());
        slackNotifier.setNotifyRegression(slackJobProperty.getNotifyRegression());
        slackNotifier.setNotifyBackToNormal(slackJobProperty.getNotifyBackToNormal());
        slackNotifier.setNotifyRepeatedFailure(slackJobProperty.getNotifyRepeatedFailure());
        slackNotifier.setIncludeTestSummary(slackJobProperty.includeTestSummary());
        slackNotifier.setCommitInfoChoice(this.getCommitInfoChoice(slackJobProperty));
        slackNotifier.setIncludeCustomMessage(slackJobProperty.includeCustomMessage());
        slackNotifier.setCustomMessage(slackJobProperty.getCustomMessage());
    }

    private CommitInfoChoice getCommitInfoChoice(SlackNotifier.SlackJobProperty slackJobProperty) {
        if (slackJobProperty.getShowCommitList()) {
            return CommitInfoChoice.AUTHORS_AND_TITLES;
        }
        return CommitInfoChoice.NONE;
    }
}

