/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.SlackService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class StandardSlackService
implements SlackService {
    private static final Logger logger = Logger.getLogger(StandardSlackService.class.getName());
    private String host = "slack.com";
    private String baseUrl;
    private String teamDomain;
    private String token;
    private String authTokenCredentialId;
    private boolean botUser;
    private String[] roomIds;

    public StandardSlackService(String baseUrl, String teamDomain, String token, String authTokenCredentialId, boolean botUser, String roomId) {
        this.baseUrl = baseUrl;
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.teamDomain = teamDomain;
        this.token = token;
        this.authTokenCredentialId = StringUtils.trim((String)authTokenCredentialId);
        this.botUser = botUser;
        this.roomIds = roomId.split("[,; ]+");
    }

    @Override
    public boolean publish(String message) {
        return this.publish(message, "warning");
    }

    @Override
    public boolean publish(String message, String color) {
        JSONObject field = new JSONObject();
        field.put("short", (Object)false);
        field.put("value", (Object)message);
        JSONArray fields = new JSONArray();
        fields.add((Object)field);
        JSONObject attachment = new JSONObject();
        attachment.put("fallback", (Object)message);
        attachment.put("color", (Object)color);
        attachment.put("fields", (Object)fields);
        JSONArray mrkdwn = new JSONArray();
        mrkdwn.add((Object)"pretext");
        mrkdwn.add((Object)"text");
        mrkdwn.add((Object)"fields");
        attachment.put("mrkdwn_in", (Object)mrkdwn);
        JSONArray attachments = new JSONArray();
        attachments.add((Object)attachment);
        return this.publish(attachments, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(JSONArray attachments, String color) {
        boolean result = true;
        for (String roomId : this.roomIds) {
            HttpPost post;
            String url;
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            if (!this.botUser || !StringUtils.isEmpty((String)this.baseUrl)) {
                url = "https://" + this.teamDomain + "." + this.host + "/services/hooks/jenkins-ci?token=" + this.getTokenToUse();
                if (!StringUtils.isEmpty((String)this.baseUrl)) {
                    url = this.baseUrl + this.getTokenToUse();
                }
                post = new HttpPost(url);
                JSONObject json = new JSONObject();
                json.put("channel", (Object)roomId);
                json.put("attachments", (Object)attachments);
                json.put("link_names", (Object)"1");
                nvps.add(new BasicNameValuePair("payload", json.toString()));
            } else {
                url = "https://slack.com/api/chat.postMessage?token=" + this.getTokenToUse() + "&channel=" + roomId + "&link_names=1&as_user=true";
                try {
                    url = url + "&attachments=" + URLEncoder.encode(attachments.toString(), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.log(Level.ALL, "Error while encoding attachments: " + e.getMessage());
                }
                post = new HttpPost(url);
            }
            logger.fine("Posting: to " + roomId + " on " + this.teamDomain + " using " + url + ": " + attachments.toString() + " " + color);
            CloseableHttpClient client = this.getHttpClient();
            try {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
                CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode != 200) {
                    HttpEntity entity = response.getEntity();
                    String responseString = EntityUtils.toString((HttpEntity)entity);
                    logger.log(Level.WARNING, "Slack post may have failed. Response: " + responseString);
                    logger.log(Level.WARNING, "Response Code: " + responseCode);
                    result = false;
                    continue;
                }
                logger.info("Posting succeeded");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error posting to Slack", e);
                result = false;
            }
            finally {
                post.releaseConnection();
            }
        }
        return result;
    }

    private String getTokenToUse() {
        StringCredentials credentials;
        if (this.authTokenCredentialId != null && !this.authTokenCredentialId.isEmpty() && (credentials = this.lookupCredentials(this.authTokenCredentialId)) != null) {
            logger.fine("Using Integration Token Credential ID.");
            return credentials.getSecret().getPlainText();
        }
        logger.fine("Using Integration Token.");
        return this.token;
    }

    private StringCredentials lookupCredentials(String credentialId) {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialId);
        return (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)matcher);
    }

    protected CloseableHttpClient getHttpClient() {
        ProxyConfiguration proxy;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        clientBuilder.setDefaultCredentialsProvider((org.apache.http.client.CredentialsProvider)credentialsProvider);
        if (Jenkins.getInstance() != null && (proxy = Jenkins.getInstance().proxy) != null) {
            HttpHost proxyHost = new HttpHost(proxy.name, proxy.port);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            String username = proxy.getUserName();
            String password = proxy.getPassword();
            if (username != null && !"".equals(username.trim())) {
                logger.info("Using proxy authentication (user=" + username + ")");
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return clientBuilder.build();
    }

    void setHost(String host) {
        this.host = host;
    }
}

