/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.ActiveNotifier;
import jenkins.plugins.slack.CommitInfoChoice;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.StandardSlackService;
import jenkins.plugins.slack.config.ItemConfigMigrator;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class SlackNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(SlackNotifier.class.getName());
    private String baseUrl;
    private String teamDomain;
    private String authToken;
    private String authTokenCredentialId;
    private boolean botUser;
    private String room;
    private String sendAs;
    private boolean startNotification;
    private boolean notifySuccess;
    private boolean notifyAborted;
    private boolean notifyNotBuilt;
    private boolean notifyUnstable;
    private boolean notifyRegression;
    private boolean notifyFailure;
    private boolean notifyBackToNormal;
    private boolean notifyRepeatedFailure;
    private boolean includeTestSummary;
    private boolean includeFailedTests;
    private CommitInfoChoice commitInfoChoice;
    private boolean includeCustomMessage;
    private String customMessage;

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    @DataBoundSetter
    public void setTeamDomain(String teamDomain) {
        this.teamDomain = teamDomain;
    }

    public String getRoom() {
        return this.room;
    }

    @DataBoundSetter
    public void setRoom(String room) {
        this.room = room;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    @DataBoundSetter
    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getAuthTokenCredentialId() {
        return this.authTokenCredentialId;
    }

    @DataBoundSetter
    public void setAuthTokenCredentialId(String authTokenCredentialId) {
        this.authTokenCredentialId = authTokenCredentialId;
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    @DataBoundSetter
    public void setBotUser(boolean botUser) {
        this.botUser = botUser;
    }

    public String getSendAs() {
        return this.sendAs;
    }

    @DataBoundSetter
    public void setSendAs(String sendAs) {
        this.sendAs = sendAs;
    }

    public boolean getStartNotification() {
        return this.startNotification;
    }

    public boolean getNotifySuccess() {
        return this.notifySuccess;
    }

    public CommitInfoChoice getCommitInfoChoice() {
        return this.commitInfoChoice;
    }

    public boolean getNotifyAborted() {
        return this.notifyAborted;
    }

    public boolean getNotifyFailure() {
        return this.notifyFailure;
    }

    public boolean getNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    public boolean getNotifyUnstable() {
        return this.notifyUnstable;
    }

    public boolean getNotifyRegression() {
        return this.notifyRegression;
    }

    public boolean getNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    public boolean includeTestSummary() {
        return this.includeTestSummary;
    }

    public boolean includeFailedTests() {
        return this.includeFailedTests;
    }

    public boolean getNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    public boolean includeCustomMessage() {
        return this.includeCustomMessage;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    @DataBoundSetter
    public void setStartNotification(boolean startNotification) {
        this.startNotification = startNotification;
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    @DataBoundSetter
    public void setCommitInfoChoice(CommitInfoChoice commitInfoChoice) {
        this.commitInfoChoice = commitInfoChoice;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    @DataBoundSetter
    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyRegression(boolean notifyRegression) {
        this.notifyRegression = notifyRegression;
    }

    @DataBoundSetter
    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    @DataBoundSetter
    public void setIncludeTestSummary(boolean includeTestSummary) {
        this.includeTestSummary = includeTestSummary;
    }

    @DataBoundSetter
    public void setNotifyRepeatedFailure(boolean notifyRepeatedFailure) {
        this.notifyRepeatedFailure = notifyRepeatedFailure;
    }

    @DataBoundSetter
    public void setIncludeCustomMessage(boolean includeCustomMessage) {
        this.includeCustomMessage = includeCustomMessage;
    }

    @DataBoundSetter
    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    @DataBoundConstructor
    public SlackNotifier() {
    }

    public SlackNotifier(String baseUrl, String teamDomain, String authToken, boolean botUser, String room, String authTokenCredentialId, String sendAs, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyRegression, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeFailedTests, CommitInfoChoice commitInfoChoice, boolean includeCustomMessage, String customMessage) {
        this.baseUrl = baseUrl;
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.teamDomain = teamDomain;
        this.authToken = authToken;
        this.authTokenCredentialId = StringUtils.trim((String)authTokenCredentialId);
        this.botUser = botUser;
        this.room = room;
        this.sendAs = sendAs;
        this.startNotification = startNotification;
        this.notifyAborted = notifyAborted;
        this.notifyFailure = notifyFailure;
        this.notifyNotBuilt = notifyNotBuilt;
        this.notifySuccess = notifySuccess;
        this.notifyUnstable = notifyUnstable;
        this.notifyRegression = notifyRegression;
        this.notifyBackToNormal = notifyBackToNormal;
        this.notifyRepeatedFailure = notifyRepeatedFailure;
        this.includeTestSummary = includeTestSummary;
        this.includeFailedTests = includeFailedTests;
        this.commitInfoChoice = commitInfoChoice;
        this.includeCustomMessage = includeCustomMessage;
        this.customMessage = customMessage;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SlackService newSlackService(AbstractBuild r, BuildListener listener) {
        String room;
        String authTokenCredentialId;
        String baseUrl;
        String teamDomain = this.teamDomain;
        if (StringUtils.isEmpty((String)teamDomain)) {
            teamDomain = this.getDescriptor().getTeamDomain();
        }
        if (StringUtils.isEmpty((String)(baseUrl = this.baseUrl))) {
            baseUrl = this.getDescriptor().getBaseUrl();
        }
        String authToken = this.authToken;
        boolean botUser = this.botUser;
        if (StringUtils.isEmpty((String)authToken)) {
            authToken = this.getDescriptor().getToken();
            botUser = this.getDescriptor().getBotUser();
        }
        if (StringUtils.isEmpty((String)(authTokenCredentialId = this.authTokenCredentialId))) {
            authTokenCredentialId = this.getDescriptor().getTokenCredentialId();
        }
        if (StringUtils.isEmpty((String)(room = this.room))) {
            room = this.getDescriptor().getRoom();
        }
        EnvVars env = null;
        try {
            env = r.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        baseUrl = env.expand(baseUrl);
        teamDomain = env.expand(teamDomain);
        authToken = env.expand(authToken);
        authTokenCredentialId = env.expand(authTokenCredentialId);
        room = env.expand(room);
        return new StandardSlackService(baseUrl, teamDomain, authToken, authTokenCredentialId, botUser, room);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        if (this.startNotification) {
            Map map = build.getProject().getPublishersList().toMap();
            for (Publisher publisher : map.values()) {
                if (!(publisher instanceof SlackNotifier)) continue;
                logger.info("Invoking Started...");
                new ActiveNotifier((SlackNotifier)publisher, listener).started(build);
            }
        }
        return super.prebuild(build, listener);
    }

    @Extension(ordinal=100.0)
    public static final class Migrator
    extends ItemListener {
        public void onLoaded() {
            logger.info("Starting Settings Migration Process");
            ItemConfigMigrator migrator = new ItemConfigMigrator();
            for (Item item : Jenkins.getInstance().getAllItems()) {
                if (migrator.migrate(item)) continue;
                logger.info(String.format("Skipping job \"%s\" with type %s", item.getName(), item.getClass().getName()));
            }
            logger.info("Completed Settings Migration Process");
        }
    }

    @Deprecated
    public static class SlackJobProperty
    extends JobProperty<AbstractProject<?, ?>> {
        private String teamDomain;
        private String token;
        private boolean botUser;
        private String room;
        private boolean startNotification;
        private boolean notifySuccess;
        private boolean notifyAborted;
        private boolean notifyNotBuilt;
        private boolean notifyUnstable;
        private boolean notifyRegression;
        private boolean notifyFailure;
        private boolean notifyBackToNormal;
        private boolean notifyRepeatedFailure;
        private boolean includeTestSummary;
        private boolean showCommitList;
        private boolean includeCustomMessage;
        private String customMessage;

        @DataBoundConstructor
        public SlackJobProperty(String teamDomain, String token, boolean botUser, String room, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyRegression, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean showCommitList, boolean includeCustomMessage, String customMessage) {
            this.teamDomain = teamDomain;
            this.token = token;
            this.botUser = botUser;
            this.room = room;
            this.startNotification = startNotification;
            this.notifyAborted = notifyAborted;
            this.notifyFailure = notifyFailure;
            this.notifyNotBuilt = notifyNotBuilt;
            this.notifySuccess = notifySuccess;
            this.notifyUnstable = notifyUnstable;
            this.notifyRegression = notifyRegression;
            this.notifyBackToNormal = notifyBackToNormal;
            this.notifyRepeatedFailure = notifyRepeatedFailure;
            this.includeTestSummary = includeTestSummary;
            this.showCommitList = showCommitList;
            this.includeCustomMessage = includeCustomMessage;
            this.customMessage = customMessage;
        }

        @Exported
        public String getTeamDomain() {
            return this.teamDomain;
        }

        @Exported
        public String getToken() {
            return this.token;
        }

        @Exported
        public boolean getBotUser() {
            return this.botUser;
        }

        @Exported
        public String getRoom() {
            return this.room;
        }

        @Exported
        public boolean getStartNotification() {
            return this.startNotification;
        }

        @Exported
        public boolean getNotifySuccess() {
            return this.notifySuccess;
        }

        @Exported
        public boolean getShowCommitList() {
            return this.showCommitList;
        }

        public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
            return super.prebuild(build, listener);
        }

        @Exported
        public boolean getNotifyAborted() {
            return this.notifyAborted;
        }

        @Exported
        public boolean getNotifyFailure() {
            return this.notifyFailure;
        }

        @Exported
        public boolean getNotifyNotBuilt() {
            return this.notifyNotBuilt;
        }

        @Exported
        public boolean getNotifyUnstable() {
            return this.notifyUnstable;
        }

        @Exported
        public boolean getNotifyRegression() {
            return this.notifyRegression;
        }

        @Exported
        public boolean getNotifyBackToNormal() {
            return this.notifyBackToNormal;
        }

        @Exported
        public boolean includeTestSummary() {
            return this.includeTestSummary;
        }

        @Exported
        public boolean getNotifyRepeatedFailure() {
            return this.notifyRepeatedFailure;
        }

        @Exported
        public boolean includeCustomMessage() {
            return this.includeCustomMessage;
        }

        @Exported
        public String getCustomMessage() {
            return this.customMessage;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String baseUrl;
        private String teamDomain;
        private String token;
        private String tokenCredentialId;
        private boolean botUser;
        private String room;
        private String sendAs;
        public static final CommitInfoChoice[] COMMIT_INFO_CHOICES = CommitInfoChoice.values();

        public DescriptorImpl() {
            this.load();
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getTeamDomain() {
            return this.teamDomain;
        }

        public String getToken() {
            return this.token;
        }

        public String getTokenCredentialId() {
            return this.tokenCredentialId;
        }

        public boolean getBotUser() {
            return this.botUser;
        }

        public String getRoom() {
            return this.room;
        }

        public String getSendAs() {
            return this.sendAs;
        }

        public ListBoxModel doFillTokenCredentialIdItems() {
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new HostnameRequirement("*.slack.com")}));
        }

        public FormValidation doCheckToken(@QueryParameter String value) {
            return FormValidation.warning((String)"Exposing your Integration Token is a security risk. Please use the Integration Token Credential ID");
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public SlackNotifier newInstance(StaplerRequest sr, JSONObject json) {
            String baseUrl = sr.getParameter("slackBaseUrl");
            if (baseUrl != null && !baseUrl.isEmpty() && !baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            String teamDomain = sr.getParameter("slackTeamDomain");
            String token = sr.getParameter("slackToken");
            String tokenCredentialId = json.getString("tokenCredentialId");
            boolean botUser = "true".equals(sr.getParameter("slackBotUser"));
            String room = sr.getParameter("slackRoom");
            boolean startNotification = "true".equals(sr.getParameter("slackStartNotification"));
            boolean notifySuccess = "true".equals(sr.getParameter("slackNotifySuccess"));
            boolean notifyAborted = "true".equals(sr.getParameter("slackNotifyAborted"));
            boolean notifyNotBuilt = "true".equals(sr.getParameter("slackNotifyNotBuilt"));
            boolean notifyUnstable = "true".equals(sr.getParameter("slackNotifyUnstable"));
            boolean notifyRegression = "true".equals(sr.getParameter("slackNotifyRegression"));
            boolean notifyFailure = "true".equals(sr.getParameter("slackNotifyFailure"));
            boolean notifyBackToNormal = "true".equals(sr.getParameter("slackNotifyBackToNormal"));
            boolean notifyRepeatedFailure = "true".equals(sr.getParameter("slackNotifyRepeatedFailure"));
            boolean includeTestSummary = "true".equals(sr.getParameter("includeTestSummary"));
            boolean includeFailedTests = "true".equals(sr.getParameter("includeFailedTests"));
            CommitInfoChoice commitInfoChoice = CommitInfoChoice.forDisplayName(sr.getParameter("slackCommitInfoChoice"));
            boolean includeCustomMessage = "on".equals(sr.getParameter("includeCustomMessage"));
            String customMessage = sr.getParameter("customMessage");
            return new SlackNotifier(baseUrl, teamDomain, token, botUser, room, tokenCredentialId, this.sendAs, startNotification, notifyAborted, notifyFailure, notifyNotBuilt, notifySuccess, notifyUnstable, notifyRegression, notifyBackToNormal, notifyRepeatedFailure, includeTestSummary, includeFailedTests, commitInfoChoice, includeCustomMessage, customMessage);
        }

        public boolean configure(StaplerRequest sr, JSONObject formData) throws Descriptor.FormException {
            this.baseUrl = sr.getParameter("slackBaseUrl");
            if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl + "/";
            }
            this.teamDomain = sr.getParameter("slackTeamDomain");
            this.token = sr.getParameter("slackToken");
            this.tokenCredentialId = formData.getJSONObject("slack").getString("tokenCredentialId");
            this.botUser = "true".equals(sr.getParameter("slackBotUser"));
            this.room = sr.getParameter("slackRoom");
            this.sendAs = sr.getParameter("slackSendAs");
            this.save();
            return super.configure(sr, formData);
        }

        SlackService getSlackService(String baseUrl, String teamDomain, String authToken, String authTokenCredentialId, boolean botUser, String room) {
            return new StandardSlackService(baseUrl, teamDomain, authToken, authTokenCredentialId, botUser, room);
        }

        public String getDisplayName() {
            return "Slack Notifications";
        }

        public FormValidation doTestConnection(@QueryParameter(value="slackBaseUrl") String baseUrl, @QueryParameter(value="slackTeamDomain") String teamDomain, @QueryParameter(value="slackToken") String authToken, @QueryParameter(value="tokenCredentialId") String authTokenCredentialId, @QueryParameter(value="slackBotUser") boolean botUser, @QueryParameter(value="slackRoom") String room) throws Descriptor.FormException {
            try {
                String message;
                SlackService testSlackService;
                boolean success;
                String targetRoom;
                String targetTokenCredentialId;
                String targetDomain;
                String targetUrl = baseUrl;
                if (targetUrl != null && !targetUrl.isEmpty() && !targetUrl.endsWith("/")) {
                    targetUrl = targetUrl + "/";
                }
                if (StringUtils.isEmpty((String)targetUrl)) {
                    targetUrl = this.baseUrl;
                }
                if (StringUtils.isEmpty((String)(targetDomain = teamDomain))) {
                    targetDomain = this.teamDomain;
                }
                String targetToken = authToken;
                boolean targetBotUser = botUser;
                if (StringUtils.isEmpty((String)targetToken)) {
                    targetToken = this.token;
                    targetBotUser = this.botUser;
                }
                if (StringUtils.isEmpty((String)(targetTokenCredentialId = authTokenCredentialId))) {
                    targetTokenCredentialId = this.tokenCredentialId;
                }
                if (StringUtils.isEmpty((String)(targetRoom = room))) {
                    targetRoom = this.room;
                }
                return (success = (testSlackService = this.getSlackService(targetUrl, targetDomain, targetToken, targetTokenCredentialId, targetBotUser, targetRoom)).publish(message = "Slack/Jenkins plugin: you're all set on " + DisplayURLProvider.get().getRoot(), "good")) ? FormValidation.ok((String)"Success") : FormValidation.error((String)"Failure");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }
    }
}

