/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.Publisher;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.slack.ActiveNotifier;
import jenkins.plugins.slack.DisabledNotifier;
import jenkins.plugins.slack.FineGrainedNotifier;
import jenkins.plugins.slack.SlackNotifier;

@Extension
public class SlackListener
extends RunListener<AbstractBuild> {
    private static final Logger logger = Logger.getLogger(SlackListener.class.getName());

    public SlackListener() {
        super(AbstractBuild.class);
    }

    public void onCompleted(AbstractBuild r, TaskListener listener) {
        this.getNotifier(r.getProject(), listener).completed(r);
        super.onCompleted((Run)r, listener);
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
    }

    public void onDeleted(AbstractBuild r) {
    }

    public void onFinalized(AbstractBuild r) {
        this.getNotifier(r.getProject(), null).finalized(r);
        super.onFinalized((Run)r);
    }

    FineGrainedNotifier getNotifier(AbstractProject project, TaskListener listener) {
        Map map = project.getPublishersList().toMap();
        for (Publisher publisher : map.values()) {
            if (!(publisher instanceof SlackNotifier)) continue;
            return new ActiveNotifier((SlackNotifier)publisher, (BuildListener)listener);
        }
        return new DisabledNotifier();
    }
}

