/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.webhook;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.webhook.RouterCommand;
import jenkins.plugins.slack.webhook.SlackRouterCommand;
import jenkins.plugins.slack.webhook.model.SlackPostData;
import jenkins.plugins.slack.webhook.model.SlackTextMessage;
import org.acegisecurity.Authentication;

public class ListProjectsCommand
extends SlackRouterCommand
implements RouterCommand<SlackTextMessage> {
    public ListProjectsCommand(SlackPostData data) {
        super(data);
    }

    @Override
    public SlackTextMessage execute(String ... args) {
        List jobs;
        ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);
        Object object = null;
        try {
            Jenkins jenkins = Jenkins.get();
            jobs = jenkins.getAllItems(AbstractProject.class);
        }
        catch (Throwable jenkins) {
            object = jenkins;
            throw jenkins;
        }
        finally {
            if (ignored != null) {
                if (object != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable jenkins) {
                        ((Throwable)object).addSuppressed(jenkins);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        StringBuilder builder = new StringBuilder("*Projects:*\n");
        for (AbstractProject job : jobs) {
            if (!job.isBuildable()) continue;
            AbstractBuild lastBuild = job.getLastBuild();
            String buildNumber = "TBD";
            String status = "TBD";
            if (lastBuild != null) {
                Result result;
                buildNumber = Integer.toString(lastBuild.getNumber());
                if (lastBuild.isBuilding()) {
                    status = "BUILDING";
                }
                if ((result = lastBuild.getResult()) != null) {
                    status = result.toString();
                }
            }
            if (jobs.size() <= 10) {
                builder.append(">*").append(job.getDisplayName()).append("*\n>*Last Build:* #").append(buildNumber).append("\n>*Status:* ").append(status).append("\n\n\n");
                continue;
            }
            builder.append(">*").append(job.getDisplayName()).append("* :: *Last Build:* #").append(buildNumber).append(" :: *Status:* ").append(status).append("\n\n");
        }
        if (jobs.size() == 0) {
            builder.append(">_No projects found_");
        }
        return new SlackTextMessage(builder.toString());
    }
}

