/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.webhook;

import hudson.model.AbstractBuild;
import hudson.model.Project;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.webhook.RouterCommand;
import jenkins.plugins.slack.webhook.SlackRouterCommand;
import jenkins.plugins.slack.webhook.model.SlackPostData;
import jenkins.plugins.slack.webhook.model.SlackTextMessage;
import org.acegisecurity.Authentication;

public class GetProjectLogCommand
extends SlackRouterCommand
implements RouterCommand<SlackTextMessage> {
    public GetProjectLogCommand(SlackPostData data) {
        super(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SlackTextMessage execute(String ... args) {
        List log;
        Object object;
        String projectName = args[0];
        String buildNumber = args[1];
        try {
            ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);
            object = null;
            try {
                Project project = (Project)Jenkins.get().getItemByFullName(projectName, Project.class);
                if (project == null) {
                    SlackTextMessage slackTextMessage = new SlackTextMessage("Could not find project (" + projectName + ")\n");
                    return slackTextMessage;
                }
                AbstractBuild build = project.getBuildByNumber(Integer.parseInt(buildNumber));
                if (build == null) {
                    SlackTextMessage slackTextMessage = new SlackTextMessage("Could not find build #" + buildNumber + " for (" + projectName + ")\n");
                    return slackTextMessage;
                }
                log = build.getLog(25);
            }
            catch (Throwable project) {
                object = project;
                throw project;
            }
            finally {
                if (ignored != null) {
                    if (object != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            return new SlackTextMessage("Error occurred returning log: " + ex.getMessage());
        }
        StringBuilder builder = new StringBuilder("*" + projectName + "* *#" + buildNumber + "*\n```");
        object = log.iterator();
        while (true) {
            if (!object.hasNext()) {
                builder.append("```");
                return new SlackTextMessage(builder.toString());
            }
            String line = (String)object.next();
            builder.append(line).append("\n");
        }
    }
}

