/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.logging;

import java.io.PrintStream;
import java.util.logging.Logger;
import jenkins.plugins.slack.logging.BuildAwareLogger;

public class SlackNotificationsLogger
implements BuildAwareLogger {
    private static final String PLUGIN_KEY = String.format("[%s]", "Slack Notifications");
    private final Logger system;
    private final PrintStream user;

    public SlackNotificationsLogger(Logger system, PrintStream user) {
        this.system = system;
        this.user = user;
    }

    @Override
    public void debug(String key, String message, Object ... args) {
        this.system.fine(() -> String.join((CharSequence)" ", key, String.format(message, args)));
    }

    @Override
    public void info(String key, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.system.info(() -> String.join((CharSequence)" ", key, formattedMessage));
        this.user.println(String.join((CharSequence)" ", PLUGIN_KEY, formattedMessage));
    }
}

