/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.decisions;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import javax.annotation.Nullable;
import jenkins.plugins.slack.logging.BuildKey;

public class Context {
    private final AbstractBuild<?, ?> current;
    private final AbstractBuild<?, ?> previous;

    public Context(AbstractBuild<?, ?> current, AbstractBuild<?, ?> previous) {
        this.current = current;
        this.previous = previous;
    }

    public String currentKey() {
        return BuildKey.format(this.current);
    }

    public Result previousResultOrSuccess() {
        if (this.previous == null || this.previous.getResult() == null) {
            return Result.SUCCESS;
        }
        return this.previous.getResult();
    }

    @Nullable
    public Result currentResult() {
        if (this.current == null) {
            return null;
        }
        return this.current.getResult();
    }
}

