/*
 * Decompiled with CFR 0.152.
 */
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SlackUploader
extends Recorder {
    private final String channel;
    private final String token;
    private final String filePath;
    private static final String CHOICE_OF_SHELL = "/bin/bash";

    @DataBoundConstructor
    public SlackUploader(String channel, String token, String filePath) {
        this.channel = channel;
        this.token = token;
        this.filePath = filePath;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getToken() {
        return this.token;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        LogOutput log = new LogOutput();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            String script = this.generateScript();
            process = this.runScript(runtime, script);
            log.logOutput(listener, process);
        }
        catch (Throwable cause) {
            log.logOutput(listener, process);
        }
        return true;
    }

    private Process runScript(Runtime runtime, String script) throws IOException {
        Process process = runtime.exec(new String[]{CHOICE_OF_SHELL, "-c", script});
        return process;
    }

    private String generateScript() {
        String loop = "for file in $(ls " + this.filePath + ");";
        loop = loop + "do ";
        String curlRequest = loop + "curl -F file=@$file -F channels=" + this.channel + " -F token=" + this.token + " https://slack.com/api/files.upload ;";
        String loopDone = curlRequest + "done;";
        return loopDone;
    }

    public BuildStepDescriptor getDescriptor() {
        SlackUploaderDescriptor slackBuilderDescriptor = (SlackUploaderDescriptor)super.getDescriptor();
        return slackBuilderDescriptor;
    }

    @Extension
    public static final class SlackUploaderDescriptor
    extends BuildStepDescriptor<Publisher> {
        public SlackUploaderDescriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Post files to Slack";
        }

        public void doHelp(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            super.doHelp(req, rsp);
        }

        public FormValidation doCheckChannel(@QueryParameter String channel) {
            if (channel.length() == 0) {
                return FormValidation.error((String)"Cannot be empty");
            }
            for (int i = 0; i < channel.length(); ++i) {
                if (channel.charAt(i) != ',' || channel.charAt(i + 1) == '#') continue;
                return FormValidation.error((String)"Channels should be specified wihtout anything between comma. eg - #ch1,#ch2,#ch3");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFilePath(@QueryParameter String filePath) {
            if (filePath.length() == 0) {
                return FormValidation.error((String)"Cannot be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckToken(@QueryParameter String token) {
            if (token.length() == 0) {
                return FormValidation.error((String)"Cannot be empty");
            }
            return FormValidation.ok();
        }

        public SlackUploader newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String channel = req.getParameter("channel");
            String token = req.getParameter("token");
            String filePath = req.getParameter("filePath");
            return new SlackUploader(channel, token, filePath);
        }
    }
}

