/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ListVMPublishedServiceStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String vmID;
    private final String vmName;
    private final String networkName;
    private final int portNumber;
    private final String publishedServiceFile;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String runtimeVMID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(ListVMPublishedServiceStep.class, "List VM Published Service");

    @DataBoundConstructor
    public ListVMPublishedServiceStep(String configurationID, String configurationFile, String vmID, String vmName, String networkName, String portNumber, String publishedServiceFile) {
        super("List VM Published Service Step");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.vmID = vmID;
        this.vmName = vmName;
        this.networkName = networkName;
        this.portNumber = Integer.parseInt(portNumber);
        this.publishedServiceFile = publishedServiceFile;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("List VM Published Service");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigFile.equals("")) {
            expConfigFile = SkytapUtils.convertFileNameToFullPath(build, expConfigFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error retrieving environment id: " + e.getMessage());
            return false;
        }
        if (!this.vmName.isEmpty()) {
            try {
                this.runtimeVMID = SkytapUtils.getVMIDFromName(this.runtimeConfigurationID, this.vmName, this.authCredentials);
            }
            catch (SkytapException e) {
                JenkinsLogger.error(e.getMessage());
                return false;
            }
        } else {
            this.runtimeVMID = this.vmID;
        }
        String requestURL = this.buildGetInterfacesURL(this.runtimeConfigurationID, this.runtimeVMID);
        HttpGet hg = SkytapUtils.buildHttpGetRequest(requestURL, this.authCredentials);
        String httpRespBody = "";
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getError());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        String interfaceId = "";
        try {
            interfaceId = this.getInterfaceId(httpRespBody, this.networkName);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Could not retrieve interface id: " + e.getMessage());
            return false;
        }
        String listServiceURL = this.buildListPublishedServiceURL(this.runtimeVMID, interfaceId, this.portNumber);
        HttpGet hget = SkytapUtils.buildHttpGetRequest(listServiceURL, this.authCredentials);
        String getResponse = "";
        try {
            getResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hget);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(getResponse);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getMessage());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        JenkinsLogger.log(getResponse);
        String externalIp = SkytapUtils.getValueFromJsonResponseBody(getResponse, "external_ip");
        String externalPort = SkytapUtils.getValueFromJsonResponseBody(getResponse, "external_port");
        String serviceOutputString = externalIp + ":" + externalPort;
        String expPublishedServiceFile = SkytapUtils.expandEnvVars(build, this.publishedServiceFile);
        expPublishedServiceFile = SkytapUtils.convertFileNameToFullPath(build, expPublishedServiceFile);
        JenkinsLogger.log("Outputting service output string: " + serviceOutputString + " to file: " + expPublishedServiceFile);
        try {
            File file = new File(expPublishedServiceFile);
            BufferedWriter output = null;
            output = new BufferedWriter(new FileWriter(file));
            output.write(serviceOutputString);
            ((Writer)output).close();
        }
        catch (IOException e) {
            JenkinsLogger.error("Skytap Plugin failed to save url to file: " + expPublishedServiceFile);
            return false;
        }
        return true;
    }

    private String buildListPublishedServiceURL(String vid, String intId, int port) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(this.runtimeConfigurationID);
        sb.append("/vms/");
        sb.append(vid);
        sb.append("/interfaces/");
        sb.append(intId);
        sb.append("/services/");
        sb.append(port);
        return sb.toString();
    }

    private String getInterfaceId(String httpResponse, String netName) throws SkytapException {
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpResponse);
        JsonObject vmObject = je.getAsJsonObject();
        JsonArray interfaceArray = (JsonArray)vmObject.get("interfaces");
        JenkinsLogger.log("Searching environment's interfaces for interface with network name: " + netName);
        for (JsonElement interfaceElement : interfaceArray) {
            String interfaceNetworkName = "";
            if (interfaceElement.getAsJsonObject().get("network_name") == null) continue;
            interfaceNetworkName = interfaceElement.getAsJsonObject().get("network_name").getAsString();
            JenkinsLogger.log("Network Name: " + interfaceNetworkName);
            if (!interfaceNetworkName.equals(netName)) continue;
            String interfaceId = interfaceElement.getAsJsonObject().get("id").getAsString();
            JenkinsLogger.log("Network Name Matched.");
            JenkinsLogger.log("Interface ID: " + interfaceId);
            return interfaceId;
        }
        throw new SkytapException("No interface was found matching network name: " + netName);
    }

    private String buildGetInterfacesURL(String cid, String vid) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(cid);
        sb.append("/vms/");
        sb.append(vid);
        JenkinsLogger.log("Request URL: " + sb.toString());
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.vmID.isEmpty() && this.vmName.isEmpty()) {
            JenkinsLogger.error("No value was provided for VM ID or name. Please provide either a valid Skytap VM ID or name.");
            return false;
        }
        if (!this.vmID.equals("") && !this.vmName.equals("")) {
            JenkinsLogger.error("Values were provided for both VM ID and name. Please provide just one or the other.");
            return false;
        }
        if (this.networkName.equals("") || this.portNumber == 0 || this.publishedServiceFile.equals("")) {
            JenkinsLogger.error("One or more arguments were omitted. Please provide all of the following: network name, port number and published service save file.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getVmID() {
        return this.vmID;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getPublishedServiceFile() {
        return this.publishedServiceFile;
    }
}

