/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateContainerStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String vmID;
    private final String vmName;
    private final String containerRegistryName;
    private final String repositoryName;
    private final String containerName;
    private final String containerCommand;
    private final Boolean exposeAllPorts;
    private final String containerSaveFilename;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String runtimeContainerRegistryId;
    @XStreamOmitField
    private String runtimeVMID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(CreateContainerStep.class, "Create Container");

    @DataBoundConstructor
    public CreateContainerStep(String configurationID, String configurationFile, String vmID, String vmName, String containerRegistryName, String repositoryName, String containerName, String containerCommand, Boolean exposeAllPorts, String containerSaveFilename) {
        super("Create Container Step");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.vmID = vmID;
        this.vmName = vmName;
        this.repositoryName = repositoryName;
        this.containerRegistryName = containerRegistryName;
        this.containerCommand = containerCommand;
        this.exposeAllPorts = exposeAllPorts;
        this.containerName = containerName;
        this.containerSaveFilename = containerSaveFilename;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Create Container");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigurationFile.isEmpty()) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error retrieving environment id: " + e.getMessage());
            return false;
        }
        try {
            this.runtimeVMID = !this.vmName.isEmpty() ? SkytapUtils.getVMIDFromName(this.runtimeConfigurationID, this.vmName, this.authCredentials) : this.vmID;
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getMessage());
            return false;
        }
        try {
            this.runtimeContainerRegistryId = SkytapUtils.getContainerRegistryIdFromName(this.containerRegistryName, this.authCredentials);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getMessage());
            return false;
        }
        BasicHttpEntity he = new BasicHttpEntity();
        he.setContentEncoding("gzip");
        he.setContentType("application/json");
        StringBuilder bodyString = new StringBuilder("{\"container_registry_id\":" + this.runtimeContainerRegistryId + ",\n");
        bodyString.append("\"repository\":\"" + this.repositoryName + "\"");
        if (!this.containerName.isEmpty()) {
            bodyString.append(",\"name\":\"" + this.containerName + "\"");
        }
        bodyString.append(",");
        bodyString.append("\"operation\": {");
        if (this.exposeAllPorts.booleanValue()) {
            bodyString.append("\"expose_all_ports\":true");
        } else {
            bodyString.append("\"expose_all_ports\":false");
        }
        if (!this.containerCommand.isEmpty()) {
            bodyString.append(",\"command\":\"" + this.containerCommand + "\"");
        }
        bodyString.append("}");
        bodyString.append("}");
        String jsonString = bodyString.toString();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            Integer len = jsonString.getBytes("UTF-8").length;
            long llen = len.longValue();
            he.setContent((InputStream)stream);
            he.setContentLength(llen);
        }
        catch (UnsupportedEncodingException e) {
            JenkinsLogger.error("Error encoding json string for vpn id: " + e.getMessage());
        }
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(this.runtimeConfigurationID);
        sb.append("/vms/");
        sb.append(this.runtimeVMID);
        sb.append("/containers");
        String createContainerURL = sb.toString();
        HttpPost hp = SkytapUtils.buildHttpPostRequest(createContainerURL, this.authCredentials);
        hp.setEntity((HttpEntity)he);
        String postResponse = "";
        JenkinsLogger.log("Creating new container created with name \"" + this.containerName + "\" ");
        try {
            postResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        JenkinsLogger.log(postResponse);
        try {
            SkytapUtils.checkResponseForErrors(postResponse);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        JenkinsLogger.log("New container created with name \"" + this.containerName + "\"");
        String expContainerSaveFile = SkytapUtils.expandEnvVars(build, this.containerSaveFilename);
        expContainerSaveFile = SkytapUtils.convertFileNameToFullPath(build, expContainerSaveFile);
        JenkinsLogger.log("Outputting container metadata  to file: " + expContainerSaveFile);
        try {
            File file = new File(expContainerSaveFile);
            BufferedWriter output = null;
            output = new BufferedWriter(new FileWriter(file));
            output.write(postResponse);
            ((Writer)output).close();
        }
        catch (IOException e) {
            JenkinsLogger.error("Skytap Plugin failed to save url to file: " + expContainerSaveFile);
            return false;
        }
        JenkinsLogger.log("Created new container with name \"" + this.containerName + "\"");
        return true;
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.vmID.isEmpty() && this.vmName.isEmpty()) {
            JenkinsLogger.error("No value was provided for VM ID or name. Please provide either a valid Skytap VM ID or name.");
            return false;
        }
        if (!this.vmID.equals("") && !this.vmName.equals("")) {
            JenkinsLogger.error("Values were provided for both VM ID and name. Please provide just one or the other.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getVmID() {
        return this.vmID;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getContainerRegistryName() {
        return this.containerRegistryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerCommand() {
        return this.containerCommand;
    }

    public Boolean getExposeAllPorts() {
        return this.exposeAllPorts;
    }

    public String getContainerSaveFilename() {
        return this.containerSaveFilename;
    }
}

