/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeVMContainerHostStatus
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String vmID;
    private final String vmName;
    private final String containerHostStatus;
    private static final int NUMBER_OF_RETRIES = 5;
    private static final int BASE_RETRY_INTERVAL_SECONDS = 20;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String runtimeVMID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(ChangeVMContainerHostStatus.class, "Change VM Container Host Status");

    @DataBoundConstructor
    public ChangeVMContainerHostStatus(String configurationID, String configurationFile, String vmID, String vmName, String containerHostStatus) {
        super("Change VM Container Host Status");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.vmID = vmID;
        this.vmName = vmName;
        this.containerHostStatus = containerHostStatus;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Changing VM Container Host Status");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigurationFile.equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        if (!this.vmName.isEmpty()) {
            try {
                this.runtimeVMID = SkytapUtils.getVMIDFromName(this.runtimeConfigurationID, this.vmName, this.authCredentials);
            }
            catch (SkytapException e) {
                JenkinsLogger.error(e.getMessage());
                return false;
            }
        } else {
            this.runtimeVMID = this.vmID;
        }
        JenkinsLogger.log("Environment ID: " + this.runtimeConfigurationID);
        JenkinsLogger.log("Environment File: " + expConfigurationFile);
        JenkinsLogger.log("VM ID: " + this.runtimeVMID);
        JenkinsLogger.log("VM Name: " + this.vmName);
        JenkinsLogger.log("Target Container Host State: " + this.containerHostStatus);
        this.sendStatusChangeRequest(this.runtimeConfigurationID, this.runtimeVMID, this.containerHostStatus);
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        if (this.vmID.isEmpty() && this.vmName.isEmpty()) {
            JenkinsLogger.error("No value was provided for VM ID or name. Please provide either a valid Skytap VM ID or name.");
            return false;
        }
        if (!this.vmID.equals("") && !this.vmName.equals("")) {
            JenkinsLogger.error("Values were provided for both VM ID and name. Please provide just one or the other.");
            return false;
        }
        return true;
    }

    private void sendStatusChangeRequest(String confId, String vmId, String tgtStatus) {
        JenkinsLogger.log("Sending state change request for environment id " + confId + " VM id " + vmId + ". Target container host status is " + tgtStatus);
        String requestURL = this.buildRequestURL(confId, vmId, tgtStatus);
        HttpPut hp = SkytapUtils.buildHttpPutRequest(requestURL, this.authCredentials);
        BasicHttpEntity he = new BasicHttpEntity();
        he.setContentEncoding("gzip");
        he.setContentType("application/json");
        String jsonString = "{\"container_host\" :false}";
        if (tgtStatus.equals("enabled")) {
            jsonString = "{\"container_host\" :true}";
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            Integer len = jsonString.getBytes("UTF-8").length;
            long llen = len.longValue();
            he.setContent((InputStream)stream);
            he.setContentLength(llen);
        }
        catch (UnsupportedEncodingException e) {
            JenkinsLogger.error("Error encoding json string for connected attribute: " + e.getMessage());
        }
        hp.setEntity((HttpEntity)he);
        String httpRespBody = "";
        try {
            SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error("Skytap Error: " + e1.getMessage());
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Error: " + e.getError());
        }
    }

    private String buildRequestURL(String configId, String vmId, String newStatus) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(configId);
        sb.append("/vms/");
        sb.append(vmId);
        sb.append(".json");
        return sb.toString();
    }

    private String getCurrentConfigurationRunstate(String skytapConfigId) throws SkytapException {
        JenkinsLogger.log("Retrieving Current Runstate ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(skytapConfigId);
        String getRequest = sb.toString();
        HttpGet hg = SkytapUtils.buildHttpGetRequest(getRequest, this.authCredentials);
        String getResponse = "";
        try {
            getResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        }
        catch (Exception e) {
            throw new SkytapException(e.getMessage());
        }
        String skytapRunstate = "";
        try {
            skytapRunstate = SkytapUtils.getValueFromJsonResponseBody(getResponse, "runstate");
        }
        catch (NullPointerException ex) {
            throw new SkytapException("Response was null or empty.");
        }
        return skytapRunstate;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getvmID() {
        return this.vmID;
    }

    public String getvmName() {
        return this.vmName;
    }

    public String getContainerHostStatus() {
        return this.containerHostStatus;
    }
}

