/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class NetworkConnectStep
extends SkytapBuilder.SkytapAction {
    private final String sourceNetworkConfigurationID;
    private final String targetNetworkConfigurationID;
    private final String sourceNetworkConfigurationFile;
    private final String targetNetworkConfigurationFile;
    private final String sourceNetworkName;
    private final String targetNetworkName;
    private static final int NUMBER_OF_RETRIES = 18;
    private static final int RETRY_INTERVAL_SECONDS = 10;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeSourceNetworkConfigurationID;
    @XStreamOmitField
    private String runtimeTargetNetworkConfigurationID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(NetworkConnectStep.class, "Connect to Network in another Environment (ICNR)");

    @DataBoundConstructor
    public NetworkConnectStep(String sourceNetworkConfigurationID, String targetNetworkConfigurationID, String sourceNetworkConfigurationFile, String targetNetworkConfigurationFile, String sourceNetworkName, String targetNetworkName) {
        super("Connect to Network in another Configuration (ICNR)");
        this.sourceNetworkConfigurationID = sourceNetworkConfigurationID;
        this.targetNetworkConfigurationID = targetNetworkConfigurationID;
        this.sourceNetworkConfigurationFile = sourceNetworkConfigurationFile;
        this.targetNetworkConfigurationFile = targetNetworkConfigurationFile;
        this.sourceNetworkName = sourceNetworkName;
        this.targetNetworkName = targetNetworkName;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        String expTargetNetworkConfigurationFile;
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Connecting to Network in another Environment");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expSourceNetworkConfigurationFile = SkytapUtils.expandEnvVars(build, this.sourceNetworkConfigurationFile);
        if (!expSourceNetworkConfigurationFile.equals("")) {
            expSourceNetworkConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expSourceNetworkConfigurationFile);
        }
        if (!(expTargetNetworkConfigurationFile = SkytapUtils.expandEnvVars(build, this.targetNetworkConfigurationFile)).equals("")) {
            expTargetNetworkConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expTargetNetworkConfigurationFile);
        }
        try {
            this.runtimeSourceNetworkConfigurationID = SkytapUtils.getRuntimeId(this.sourceNetworkConfigurationID, expSourceNetworkConfigurationFile);
            this.runtimeTargetNetworkConfigurationID = SkytapUtils.getRuntimeId(this.targetNetworkConfigurationID, expTargetNetworkConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        String runtimeSourceNetworkID = "";
        String runtimeTargetNetworkID = "";
        try {
            runtimeSourceNetworkID = SkytapUtils.getNetworkIdFromName(this.runtimeSourceNetworkConfigurationID, this.sourceNetworkName, this.authCredentials);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getError());
            return false;
        }
        try {
            runtimeTargetNetworkID = SkytapUtils.getNetworkIdFromName(this.runtimeTargetNetworkConfigurationID, this.targetNetworkName, this.authCredentials);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getError());
            return false;
        }
        if (runtimeSourceNetworkID.equals("") || runtimeTargetNetworkID.equals("")) {
            JenkinsLogger.error("Unable to obtain network identifiers.");
            return false;
        }
        if (!this.checkIsTargetNetworkAvailable(this.runtimeTargetNetworkConfigurationID, runtimeTargetNetworkID).booleanValue()) {
            JenkinsLogger.error("Target network has not become available. Failing build step.");
            return false;
        }
        try {
            this.sendNetConnectRequest(runtimeSourceNetworkID, runtimeTargetNetworkID);
        }
        catch (SkytapException e) {
            if (e.getMessage().contains("networks are already connected")) {
                JenkinsLogger.error("The source and target networks were already connected. Passing build step.");
                return true;
            }
            JenkinsLogger.error("Skytap Error: " + e.getMessage());
            return false;
        }
        JenkinsLogger.defaultLogMessage("Networks " + this.sourceNetworkName + " and " + this.targetNetworkName + " have been connected successfully.");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private void sendNetConnectRequest(String sourceNetId, String targetNetId) throws SkytapException {
        JenkinsLogger.log("Sending network connection request for source: " + sourceNetId + " to target: " + targetNetId);
        String requestURL = this.buildRequestURL(sourceNetId, targetNetId);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(requestURL, this.authCredentials);
        String httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        if (httpRespBody.equals("")) {
            throw new SkytapException("Request Failed. No HTTP response was returned.");
        }
        SkytapUtils.checkResponseForErrors(httpRespBody);
    }

    private String buildRequestURL(String sid, String tid) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("tunnels?");
        sb.append("source_network_id=");
        sb.append(sid);
        sb.append("&target_network_id=");
        sb.append(tid);
        return sb.toString();
    }

    private String buildCheckTargetNetworkURL(String confId, String netId) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(confId);
        sb.append("/networks/");
        sb.append(netId);
        JenkinsLogger.log("Request URL: " + sb.toString());
        return sb.toString();
    }

    private Boolean checkIsTargetNetworkAvailable(String tgtConfigId, String tgtNetId) {
        JenkinsLogger.log("Checking availability of target network with id: " + tgtNetId + " in environment with id: " + tgtConfigId);
        String requestURL = this.buildCheckTargetNetworkURL(tgtConfigId, tgtNetId);
        HttpGet hg = SkytapUtils.buildHttpGetRequest(requestURL, this.authCredentials);
        String httpRespBody = "";
        Boolean networkIsAvailable = false;
        try {
            int pollAttempts = 0;
            while (!networkIsAvailable.booleanValue()) {
                if (pollAttempts >= 18) break;
                JsonParser parser = new JsonParser();
                httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
                JsonElement je = parser.parse(httpRespBody);
                JsonObject jo = je.getAsJsonObject();
                if (jo.get("status") == null) {
                    JenkinsLogger.log("Target network is available.");
                    return true;
                }
                if (jo.get("status").getAsString().equals("not_busy")) {
                    networkIsAvailable = true;
                    JenkinsLogger.log("Target network is available.");
                } else {
                    networkIsAvailable = false;
                    JenkinsLogger.log("Target network is busy.");
                    int sleepTime = 10;
                    JenkinsLogger.log("Sleeping for " + sleepTime + " seconds.");
                    Thread.sleep(sleepTime * 1000);
                }
                ++pollAttempts;
            }
            return networkIsAvailable;
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getError());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        catch (InterruptedException e1) {
            JenkinsLogger.error(e1.getMessage());
            return false;
        }
    }

    private Boolean preFlightSanityChecks() {
        if (!this.sourceNetworkConfigurationFile.equals("") && !this.sourceNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("Values were provided for both source environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (!this.targetNetworkConfigurationFile.equals("") && !this.targetNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("Values were provided for both target environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.sourceNetworkConfigurationFile.equals("") && this.sourceNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.targetNetworkConfigurationFile.equals("") && this.targetNetworkConfigurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.targetNetworkName.equals("")) {
            JenkinsLogger.error("No value was provided for target network name. Please provide a valid target network name.");
            return false;
        }
        if (this.sourceNetworkName.equals("")) {
            JenkinsLogger.error("No value was provided for source network name. Please provide a valid source network name.");
            return false;
        }
        return true;
    }

    public SkytapGlobalVariables getGlobalVars() {
        return this.globalVars;
    }

    public String getSourceNetworkConfigurationID() {
        return this.sourceNetworkConfigurationID;
    }

    public String getTargetNetworkConfigurationID() {
        return this.targetNetworkConfigurationID;
    }

    public String getSourceNetworkConfigurationFile() {
        return this.sourceNetworkConfigurationFile;
    }

    public String getTargetNetworkConfigurationFile() {
        return this.targetNetworkConfigurationFile;
    }

    public String getSourceNetworkName() {
        return this.sourceNetworkName;
    }

    public String getTargetNetworkName() {
        return this.targetNetworkName;
    }
}

