/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateTemplateFromConfigurationStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String templateName;
    private final String templateDescription;
    private final String templateSaveFilename;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String runtimeTemplateID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(CreateTemplateFromConfigurationStep.class, "Create Template from Environment");

    @DataBoundConstructor
    public CreateTemplateFromConfigurationStep(String configurationID, String configurationFile, String templateName, String templateDescription, String templateSaveFilename) {
        super("Create Template from Configuration");
        this.configurationFile = configurationFile;
        this.configurationID = configurationID;
        this.templateDescription = templateDescription;
        this.templateName = templateName;
        this.templateSaveFilename = templateSaveFilename;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        String httpRespBody;
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Creating Template from Environment");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigurationFile.equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        String expTemplateFile = SkytapUtils.expandEnvVars(build, this.templateSaveFilename);
        String expTemplateName = SkytapUtils.expandEnvVars(build, this.templateName);
        String expTemplateDescription = SkytapUtils.expandEnvVars(build, this.templateDescription);
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e2) {
            JenkinsLogger.error("Error obtaining environment id: " + e2.getMessage());
            return false;
        }
        JenkinsLogger.log("Runtime Environment ID: " + this.runtimeConfigurationID);
        try {
            this.sendTemplateCreationRequest(this.runtimeConfigurationID);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error("Skytap Exception: " + e1.getMessage());
            return false;
        }
        if (this.runtimeTemplateID.equals("") || this.runtimeTemplateID == null) {
            JenkinsLogger.error("Template creation failed.");
            return false;
        }
        try {
            httpRespBody = this.sendTemplateUpdateRequest(this.runtimeTemplateID, expTemplateName, expTemplateDescription);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error("Skytap Exception: " + e1.getMessage());
            return false;
        }
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonObject jo = je.getAsJsonObject();
        jo = je.getAsJsonObject();
        BufferedWriter output = null;
        expTemplateFile = SkytapUtils.convertFileNameToFullPath(build, expTemplateFile);
        File file = new File(expTemplateFile);
        try {
            output = new BufferedWriter(new FileWriter(file));
            output.write(httpRespBody);
            ((Writer)output).close();
        }
        catch (IOException e) {
            JenkinsLogger.error("Skytap Plugin failed to save template to file: " + expTemplateFile);
            return false;
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            JenkinsLogger.error("Error: " + e.getMessage());
        }
        JenkinsLogger.defaultLogMessage("Template " + expTemplateName + " successfully created and saved to file: " + expTemplateFile);
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private void sendTemplateCreationRequest(String configId) throws SkytapException {
        JenkinsLogger.log("Sending Template Creation Request for Environment " + configId);
        String templateCreateRequestUrl = this.buildRequestCreationURL(configId);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(templateCreateRequestUrl, this.authCredentials);
        String httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        SkytapUtils.checkResponseForErrors(httpRespBody);
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        this.runtimeTemplateID = je.getAsJsonObject().get("id").getAsString();
        String newName = je.getAsJsonObject().get("name").getAsString();
        JenkinsLogger.log("New Template created with id: " + this.runtimeTemplateID + " - name: " + newName);
    }

    private String sendTemplateUpdateRequest(String templateId, String name, String desc) throws SkytapException {
        JenkinsLogger.log("Sending Template Update Request for Template " + templateId);
        JenkinsLogger.log("Updating Template with name: " + name + " and description: " + desc);
        String reqUrl = this.buildRequestUpdateURL(templateId, name, desc);
        HttpPut hp = SkytapUtils.buildHttpPutRequest(reqUrl, this.authCredentials);
        String httpResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        return httpResponse;
    }

    private String buildRequestUpdateURL(String templateId, String name, String desc) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("templates/");
        sb.append(templateId);
        sb.append("?name=");
        sb.append(URLEncoder.encode(name));
        sb.append("&description=");
        sb.append(URLEncoder.encode(desc));
        return sb.toString();
    }

    private String buildRequestCreationURL(String configId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("templates?configuration_id=");
        sb.append(configId);
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.templateName.equals("") || this.templateSaveFilename.equals("")) {
            JenkinsLogger.error("Please provide a template name and a valid filename to save to.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getTemplateSaveFilename() {
        return this.templateSaveFilename;
    }
}

