/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddTemplateToProjectStep
extends SkytapBuilder.SkytapAction {
    private final String templateID;
    private final String templateFile;
    private final String projectID;
    private final String projectName;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeTemplateID;
    @XStreamOmitField
    private String runtimeProjectID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(AddTemplateToProjectStep.class, "Add Template to Project");

    @DataBoundConstructor
    public AddTemplateToProjectStep(String templateID, String templateFile, String projectID, String projectName) {
        super("Add Template to Project");
        this.templateID = templateID;
        this.templateFile = templateFile;
        this.projectID = projectID;
        this.projectName = projectName;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Adding Template to Project Step");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expTemplateFile = SkytapUtils.expandEnvVars(build, this.templateFile);
        if (!expTemplateFile.isEmpty()) {
            expTemplateFile = SkytapUtils.convertFileNameToFullPath(build, expTemplateFile);
        }
        try {
            this.runtimeTemplateID = SkytapUtils.getRuntimeId(this.templateID, expTemplateFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        if (!this.getProjectID().equals("")) {
            this.runtimeProjectID = this.getProjectID();
        }
        if (!this.getProjectName().equals("")) {
            this.runtimeProjectID = SkytapUtils.getProjectID(this.projectName, this.authCredentials);
        }
        if (this.runtimeProjectID.equals("")) {
            JenkinsLogger.error("Please provide a valid project name or ID.");
            return false;
        }
        JenkinsLogger.log("Template ID: " + this.runtimeTemplateID);
        JenkinsLogger.log("Template File: " + this.templateFile);
        JenkinsLogger.log("Project ID: " + this.runtimeProjectID);
        JenkinsLogger.log("Project Name: " + this.projectName);
        String reqUrl = this.buildAddTemplateRequestURL(this.runtimeProjectID, this.runtimeTemplateID);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(reqUrl, this.authCredentials);
        String httpRespBody = "";
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getError());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        JenkinsLogger.log("Template " + this.runtimeTemplateID + " was successfully added to project " + this.runtimeProjectID);
        return true;
    }

    private String buildAddTemplateRequestURL(String projId, String templateId) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com");
        sb.append("/projects/");
        sb.append(projId);
        sb.append("/templates/");
        sb.append(templateId);
        JenkinsLogger.log("Request URL: " + sb.toString());
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.templateID.equals("") && !this.templateFile.equals("")) {
            JenkinsLogger.error("Values were provided for both template id and file. Please provide just one or the other.");
            return false;
        }
        if (!this.templateID.equals("") && !this.templateFile.equals("")) {
            JenkinsLogger.error("No value was provided for template ID or file. Please provide either a valid Skytap template ID, or a valid template file.");
            return false;
        }
        if (!this.projectID.equals("") && !this.projectName.equals("")) {
            JenkinsLogger.error("Values were provided for both project ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.projectID.equals("") && this.projectName.equals("")) {
            JenkinsLogger.error("No value was provided for project ID or name. Please provide either the name or ID of a valid Skytap project.");
            return false;
        }
        return true;
    }

    public String getTemplateID() {
        return this.templateID;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRuntimeTemplateID() {
        return this.runtimeTemplateID;
    }

    public void setRuntimeTemplateID(String runtimeTemplateID) {
        this.runtimeTemplateID = runtimeTemplateID;
    }
}

