/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddConfigurationToProjectStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String projectID;
    private final String projectName;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(AddConfigurationToProjectStep.class, "Add Configuration to Project");

    @DataBoundConstructor
    public AddConfigurationToProjectStep(String configurationID, String configurationFile, String projectID, String projectName) {
        super("Add Configuration to Project");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.projectID = projectID;
        this.projectName = projectName;
    }

    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        String httpRespBody;
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Adding Configuration to Project Step");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage(this.projectName);
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigurationFile.equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        String runtimeProjectID = "";
        if (!this.getProjectID().equals("")) {
            runtimeProjectID = this.getProjectID();
        }
        if (!this.getProjectName().equals("")) {
            runtimeProjectID = SkytapUtils.getProjectID(this.projectName, this.authCredentials);
        }
        if (runtimeProjectID.equals("")) {
            JenkinsLogger.error("Please provide a valid project name or ID.");
            return false;
        }
        JenkinsLogger.log("Configuration ID: " + this.runtimeConfigurationID);
        JenkinsLogger.log("Configuration File: " + this.configurationFile);
        JenkinsLogger.log("Project ID: " + runtimeProjectID);
        JenkinsLogger.log("Project Name: " + this.projectName);
        String requestUrl = this.buildRequestURL(runtimeProjectID, this.runtimeConfigurationID);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(requestUrl, this.authCredentials);
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getError());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        JenkinsLogger.log("");
        JenkinsLogger.log(httpRespBody);
        JenkinsLogger.log("");
        JenkinsLogger.defaultLogMessage("Configuration " + this.runtimeConfigurationID + " was successfully added to project " + runtimeProjectID);
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private String buildRequestURL(String projId, String configId) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com");
        sb.append("/projects/");
        sb.append(projId);
        sb.append("/configurations/");
        sb.append(configId);
        JenkinsLogger.log("Request URL: " + sb.toString());
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both configuration ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for configuration ID or file. Please provide either a valid Skytap configuration ID, or a valid configuration file.");
            return false;
        }
        if (!this.projectID.equals("") && !this.projectName.equals("")) {
            JenkinsLogger.error("Values were provided for both project ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.projectID.equals("") && this.projectName.equals("")) {
            JenkinsLogger.error("No value was provided for project ID or name. Please provide either the name or ID of a valid Skytap project.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

