/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkytapBuildWrapper
extends BuildWrapper {
    private final String userId;
    private final String authKey;

    @DataBoundConstructor
    public SkytapBuildWrapper(String userId, String authKey) {
        this.userId = userId;
        this.authKey = authKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.put("userId", this.userId);
        env.put("authKey", this.authKey);
        return new BuildWrapper.Environment(){};
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        variables.put("userId", this.userId);
        variables.put("authKey", this.authKey);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Skytap Cloud Authentication Credentials";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

