/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateConfigurationStep
extends SkytapBuilder.SkytapAction {
    private final String templateID;
    private final String templateFile;
    private final String configFile;
    @XStreamOmitField
    private String runtimeTemplateID;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(CreateConfigurationStep.class, "Create Configuration from Template");

    @DataBoundConstructor
    public CreateConfigurationStep(String templateID, String templateFile, String configFile) {
        super("Create Configuration from Template");
        this.templateID = templateID;
        this.templateFile = templateFile;
        this.configFile = configFile;
    }

    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Creating Configuration from Template");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expTemplateFile = SkytapUtils.expandEnvVars(build, this.templateFile);
        String expConfigFile = SkytapUtils.expandEnvVars(build, this.configFile);
        JenkinsLogger.log("Template File: " + expTemplateFile);
        JenkinsLogger.log("Config File: " + expConfigFile);
        try {
            this.runtimeTemplateID = SkytapUtils.getRuntimeId(this.templateID, expTemplateFile);
        }
        catch (FileNotFoundException e1) {
            JenkinsLogger.error("Error obtaining template id: " + e1.getMessage());
            return false;
        }
        JenkinsLogger.log("Template ID:  " + this.runtimeTemplateID);
        String requestURL = this.buildCreateConfigRequestURL(this.runtimeTemplateID);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(requestURL, this.authCredentials);
        String httpRespBody = "";
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error("Skytap Exception: " + e1.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getError());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonObject jo = je.getAsJsonObject();
        jo = je.getAsJsonObject();
        BufferedWriter output = null;
        File file = new File(expConfigFile);
        try {
            output = new BufferedWriter(new FileWriter(file));
            output.write(httpRespBody);
            ((Writer)output).close();
        }
        catch (IOException e) {
            JenkinsLogger.error("Skytap Plugin failed to save configuration to file: " + expConfigFile);
            return false;
        }
        JenkinsLogger.defaultLogMessage("Configuration successfully created and saved to file: " + expConfigFile);
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    public String buildCreateConfigRequestURL(String templateId) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append("?template_id=");
        sb.append(templateId);
        JenkinsLogger.log("Request URL: " + sb.toString());
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.templateID.equals("") && !this.templateFile.equals("")) {
            JenkinsLogger.error("Values were provided for both template ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.templateID.equals("") && this.templateFile.equals("")) {
            JenkinsLogger.error("No value was provided for template ID or file. Please provide either a valid Skytap template ID, or a valid template file.");
            return false;
        }
        if (this.configFile.equals("")) {
            JenkinsLogger.error("No value was provided for the configuration file. Please provide a valid config file value.");
            return false;
        }
        return true;
    }

    public String getTemplateID() {
        return this.templateID;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }
}

