/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConnectToVPNTunnelStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String configurationNetworkName;
    private final String vpnID;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(ConnectToVPNTunnelStep.class, "Connect to VPN Tunnel");

    @DataBoundConstructor
    public ConnectToVPNTunnelStep(String configurationID, String configurationFile, String configurationNetworkName, String vpnID) {
        super("Connect to VPN Tunnel");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.configurationNetworkName = configurationNetworkName;
        this.vpnID = vpnID;
    }

    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Connecting to VPN Tunnel");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        JenkinsLogger.log("Getting the ID for network: " + this.configurationNetworkName);
        String runtimeNetworkID = "";
        try {
            runtimeNetworkID = SkytapUtils.getNetworkIdFromName(this.runtimeConfigurationID, this.configurationNetworkName, this.authCredentials);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getError());
            return false;
        }
        if (runtimeNetworkID.equals("")) {
            JenkinsLogger.error("Failed to obtain network ID.");
            return false;
        }
        JenkinsLogger.log("Configuration ID: " + this.runtimeConfigurationID);
        JenkinsLogger.log("Configuration File: " + expConfigurationFile);
        JenkinsLogger.log("Network ID: " + runtimeNetworkID);
        JenkinsLogger.log("Network Name: " + this.configurationNetworkName);
        JenkinsLogger.log("VPN ID: " + this.vpnID);
        JenkinsLogger.log("Attaching VPN to Configuration ...");
        String attachResponse = this.attachVPNToConfiguration(this.runtimeConfigurationID, runtimeNetworkID, this.vpnID);
        JenkinsLogger.log("Attach Response: " + attachResponse);
        if (attachResponse.equals("") || attachResponse == null) {
            JenkinsLogger.error("Response was null or empty.");
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(attachResponse);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Error: " + e.getError());
            return false;
        }
        JenkinsLogger.log("VPN with ID " + this.vpnID + " successfully attached to Network with ID " + runtimeNetworkID + ".");
        JenkinsLogger.log("Connecting VPN to Configuration ...");
        String connectResponse = this.connectVPNToConfiguration(this.runtimeConfigurationID, runtimeNetworkID, this.vpnID);
        JenkinsLogger.log("Connect Response: " + connectResponse);
        if (connectResponse.equals("") || connectResponse == null) {
            JenkinsLogger.error("Response was null or empty.");
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(connectResponse);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Error: " + e.getError());
            return false;
        }
        JenkinsLogger.defaultLogMessage("VPN with ID " + this.vpnID + " successfully connected to Network with ID " + runtimeNetworkID + ".");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private String connectVPNToConfiguration(String confId, String networkId, String vpnId) {
        String reqUrl = this.buildConnectRequestURL(confId, networkId, vpnId);
        HttpPut hp = SkytapUtils.buildHttpPutRequest(reqUrl, this.authCredentials);
        BasicHttpEntity he = new BasicHttpEntity();
        he.setContentEncoding("gzip");
        he.setContentType("application/json");
        String jsonString = "{\"connected\" :true}";
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            Integer len = jsonString.getBytes("UTF-8").length;
            long llen = len.longValue();
            he.setContent((InputStream)stream);
            he.setContentLength(llen);
        }
        catch (UnsupportedEncodingException e) {
            JenkinsLogger.error("Error encoding json string for connected attribute: " + e.getMessage());
        }
        hp.setEntity((HttpEntity)he);
        String response = "";
        try {
            response = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
        }
        return response;
    }

    private String buildConnectRequestURL(String confId, String networkId, String vpnId) {
        String req = this.buildRequestURL(confId, networkId);
        StringBuilder sb = new StringBuilder(req);
        sb.append("/");
        sb.append(vpnId);
        sb.append("/");
        JenkinsLogger.log(sb.toString());
        return sb.toString();
    }

    private String buildRequestURL(String confId, String networkId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(confId);
        sb.append("/networks/");
        sb.append(networkId);
        sb.append("/vpns");
        String requestUrl = sb.toString();
        return requestUrl;
    }

    private String attachVPNToConfiguration(String confId, String networkId, String vpnId) {
        String requestUrl = this.buildRequestURL(confId, networkId);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(requestUrl, this.authCredentials);
        BasicHttpEntity he = new BasicHttpEntity();
        he.setContentEncoding("gzip");
        he.setContentType("application/json");
        String jsonString = "{\"id\":\"" + vpnId + "\"}";
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            Integer len = jsonString.getBytes("UTF-8").length;
            long llen = len.longValue();
            he.setContent((InputStream)stream);
            he.setContentLength(llen);
        }
        catch (UnsupportedEncodingException e) {
            JenkinsLogger.error("Error encoding json string for vpn id: " + e.getMessage());
        }
        hp.setEntity((HttpEntity)he);
        JenkinsLogger.log("HTTP POST request: " + hp.toString());
        String httpRespBody = "";
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
        }
        return httpRespBody;
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both configuration ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for configuration ID or file. Please provide either a valid Skytap configuration ID, or a valid configuration file.");
            return false;
        }
        if (this.vpnID.equals("")) {
            JenkinsLogger.error("No value was provided for the VPN ID. Please provide a valid Skytap VPN ID.");
            return false;
        }
        if (this.configurationNetworkName.equals("")) {
            JenkinsLogger.error("No value was provided for the network name. Please provide a valid Skytap Network name.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getConfigurationNetworkName() {
        return this.configurationNetworkName;
    }

    public String getVpnID() {
        return this.vpnID;
    }
}

