/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SkytapBuilder
extends Builder {
    private final SkytapAction action;

    @DataBoundConstructor
    public SkytapBuilder(SkytapAction action) {
        this.action = action;
    }

    public SkytapAction getAction() {
        return this.action;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String uid = this.getDescriptor().getUserId();
        String authkey = this.getDescriptor().getAuthKey();
        String cred = uid + ":" + authkey;
        String encodedCred = SkytapUtils.encodeAuthCredentials(cred);
        SkytapGlobalVariables globalVars = new SkytapGlobalVariables(encodedCred, this.getDescriptor().isLoggingEnabled());
        JenkinsLogger theLogger = new JenkinsLogger(listener, this.getDescriptor().isLoggingEnabled());
        Boolean stepSucceeded = this.action.executeStep(build, globalVars);
        return stepSucceeded;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String userId;
        private String authKey;
        private Boolean loggingEnabled;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute Skytap Action";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.userId = formData.getString("userId");
            this.authKey = formData.getString("authKey");
            this.loggingEnabled = formData.getBoolean("loggingEnabled");
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doValidate(@QueryParameter(value="configurationID") String accessId, @QueryParameter(value="configurationFile") String secretKey) throws IOException, ServletException {
            return FormValidation.error((String)"BLAH");
        }

        public String getUserId() {
            return this.userId;
        }

        public String getAuthKey() {
            return this.authKey;
        }

        public Boolean isLoggingEnabled() {
            return this.loggingEnabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SkytapActionDescriptor
    extends Descriptor<SkytapAction> {
        private String displayName;

        public SkytapActionDescriptor(Class<? extends SkytapAction> clazz, String displayName) {
            super(clazz);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public FormValidation doCheckConfigurationID(@QueryParameter String configurationID, @QueryParameter String configurationFile) throws IOException, ServletException {
            try {
                if (!configurationID.equals("")) {
                    Integer.parseInt(configurationID);
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please enter a valid integer for the configuration ID.");
            }
            if (!configurationID.equals("") && !configurationFile.equals("")) {
                return FormValidation.error((String)"Please enter either a valid configuration ID or a valid configuration file. Build step will fail if both values are entered.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckConfigurationFile(@QueryParameter String configurationFile) {
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectID(@QueryParameter String projectID, @QueryParameter String projectName) {
            try {
                if (!projectID.equals("")) {
                    Integer.parseInt(projectID);
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please enter a valid integer for the project ID.");
            }
            if (!projectID.equals("") && !projectName.equals("")) {
                return FormValidation.error((String)"Please enter either a valid project ID or a valid project name. Build step will fail if both values are entered.");
            }
            return FormValidation.ok();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SkytapAction
    implements ExtensionPoint,
    Describable<SkytapAction> {
        public String displayName;

        public SkytapAction(String displayName) {
            this.displayName = displayName;
        }

        public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
            return true;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Descriptor<SkytapAction> getDescriptor() {
            return Hudson.getInstance().getDescriptor(this.getClass());
        }
    }
}

