/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeleteConfigurationStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(DeleteConfigurationStep.class, "Delete Configuration");

    @DataBoundConstructor
    public DeleteConfigurationStep(String configurationID, String configurationFile) {
        super("Delete Configuration");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
    }

    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        String httpRespBody;
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Delete Configuration");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error retrieving configuration id: " + e.getMessage());
            return false;
        }
        JenkinsLogger.log("Sending delete request for configuration id " + this.runtimeConfigurationID);
        String requestURL = this.buildRequestURL(this.runtimeConfigurationID);
        HttpDelete hd = SkytapUtils.buildHttpDeleteRequest(requestURL, globalVars.getEncodedCredentials());
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hd);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getError());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        JenkinsLogger.log("");
        JenkinsLogger.log(httpRespBody);
        JenkinsLogger.log("");
        JenkinsLogger.defaultLogMessage("Configuration " + this.runtimeConfigurationID + " was successfully deleted.");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    public String buildRequestURL(String configId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(configId);
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both configuration ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for configuration ID or file. Please provide either a valid Skytap configuration ID, or a valid configuration file.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }
}

