/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.chefbuilder;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.chefbuilder.ChefThread;
import org.jenkinsci.plugins.chefbuilder.ChefXmlParser;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ChefBuilderConfiguration
extends Builder
implements SimpleBuildStep {
    public final String url;
    public final String sinatraurl;
    public final String filter;
    public final boolean parallel;
    public final boolean fail;
    public final int port;
    public final String username;
    public final String command;
    public final String privatekey;
    public static List<String> nodes = new ArrayList<String>();
    public String node;

    @DataBoundConstructor
    public ChefBuilderConfiguration(String url, String sinatraurl, String filter, String username, int port, String command, String privatekey, boolean parallel, boolean fail) {
        this.url = url;
        this.sinatraurl = sinatraurl;
        this.filter = filter;
        this.username = username;
        this.port = port;
        this.command = command;
        this.privatekey = privatekey;
        this.parallel = parallel;
        this.fail = fail;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSinatraurl() {
        return this.sinatraurl;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean getParallel() {
        return this.parallel;
    }

    public boolean getFail() {
        return this.fail;
    }

    public String getUsername() {
        return this.username;
    }

    public int getPort() {
        return this.port;
    }

    public String getCommand() {
        return this.command;
    }

    public String getPrivatekey() {
        return this.privatekey;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Object output = null;
        listener.getLogger().println("Execute chef-client in parallel is set to : " + this.parallel);
        listener.getLogger().println("Fail the build if the command fails to run on any of the chef node is set to : " + this.fail);
        ChefXmlParser parser = new ChefXmlParser();
        List nodes = parser.getListofNodes(this.filter, this.sinatraurl);
        listener.getLogger().println("The nodes are : " + nodes);
        int MYTHREADS = nodes.size();
        ExecutorService executor = Executors.newFixedThreadPool(MYTHREADS);
        ArrayList<Future<String>> list = new ArrayList<Future<String>>();
        for (int j = 0; j < nodes.size(); ++j) {
            this.node = (String)nodes.get(j);
            ChefThread chefThread = new ChefThread(this.node, this.username, this.port, this.privatekey, this.command);
            Future<String> future = executor.submit(chefThread);
            list.add(future);
        }
        for (Future future : list) {
            try {
                listener.getLogger().println(new Date() + "::" + (String)future.get());
            }
            catch (Exception e) {
                e.printStackTrace();
                listener.getLogger().println(e);
            }
        }
        executor.shutdown();
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> arg0, FilePath arg1, Launcher arg2, TaskListener arg3) throws InterruptedException, IOException {
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String sinatraurl, String filter) throws IOException {
            try {
                URL url1 = new URL(url);
                URL url2 = new URL(sinatraurl);
                HttpURLConnection connection = (HttpURLConnection)url1.openConnection();
                HttpURLConnection connection1 = (HttpURLConnection)url2.openConnection();
                connection.setRequestMethod("GET");
                connection1.setRequestMethod("GET");
                connection.connect();
                connection1.connect();
                int code = connection.getResponseCode();
                int sinatracode = connection1.getResponseCode();
                if (code == 200 && sinatracode == 200) {
                    return FormValidation.ok((String)"SUCCESS: able to connect chef server URL and sinatra URL");
                }
                return FormValidation.error((String)("connection to chef server web URL OR Sinatra web URL is failed. The HTTP URL connection code for chef server URL is" + code + " and connection code for sinatra web URL is " + sinatracode));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return FormValidation.error((String)"some issue while connecting to chef OR sinatra web server URL");
            }
        }

        public FormValidation doValidate(@QueryParameter String filter) {
            try {
                String pattern = "(.*)(::)(.*),(.*)(::)(.*)";
                String pattern1 = "(.*)(::)(.*)";
                Pattern r = Pattern.compile(pattern);
                Pattern r1 = Pattern.compile(pattern1);
                Matcher m = r.matcher(filter);
                Matcher m1 = r1.matcher(filter);
                if (m.find()) {
                    return FormValidation.ok((String)"SUCCESS. however, there may be multiple strings matching same pattern. That might be not correct. Be careful !!!");
                }
                if (m1.find()) {
                    return FormValidation.ok((String)"SUCCESS. however, there may be multiple strings matching same pattern. That might be not correct. Be careful !!!");
                }
                return FormValidation.warning((String)"seems the filter is not in correct format");
            }
            catch (Exception e) {
                return FormValidation.error((String)"some issue");
            }
        }

        public FormValidation doFetch(@QueryParameter String filter, @QueryParameter String sinatraurl) {
            try {
                ChefXmlParser a = new ChefXmlParser();
                nodes = a.getListofNodes(filter, sinatraurl);
            }
            catch (Exception e) {
                e.printStackTrace();
                return FormValidation.warning((String)"Some issue while fetching nodes");
            }
            return FormValidation.ok((String)("The nodes are " + nodes));
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute chef client on selected nodes";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

