/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.FilePath;
import hudson.model.Queue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.jvnet.hudson.plugins.shelveproject.DeleteProjectExecutable;
import org.jvnet.hudson.plugins.shelveproject.ShelvedProject;

public class UnshelveProjectExecutable
implements Queue.Executable {
    private static final Logger LOGGER = Logger.getLogger(UnshelveProjectExecutable.class.getName());
    private final String[] shelvedProjectArchiveNames;
    private final Queue.Task parentTask;

    public UnshelveProjectExecutable(Queue.Task parentTask, String[] shelvedProjectArchiveNames) {
        this.parentTask = parentTask;
        this.shelvedProjectArchiveNames = shelvedProjectArchiveNames != null ? Arrays.copyOf(shelvedProjectArchiveNames, shelvedProjectArchiveNames.length) : null;
    }

    public Queue.Task getParent() {
        return this.parentTask;
    }

    public void run() {
        for (String shelvedProjectArchiveName : this.shelvedProjectArchiveNames) {
            File shelvedProjectArchive = DeleteProjectExecutable.getArchiveFile(shelvedProjectArchiveName);
            LOGGER.info("Unshelving project [" + shelvedProjectArchiveName + "].");
            try {
                boolean correctlyExploded;
                if ("tar".equals(FilenameUtils.getExtension((String)shelvedProjectArchiveName))) {
                    correctlyExploded = this.explode(shelvedProjectArchive);
                    if (correctlyExploded) {
                        Files.delete(ShelvedProject.getMetadataFileFromArchive(shelvedProjectArchive));
                    }
                } else {
                    this.legacyExplode(shelvedProjectArchive);
                    correctlyExploded = true;
                }
                if (correctlyExploded) {
                    Files.delete(shelvedProjectArchive.toPath());
                } else {
                    LOGGER.log(Level.INFO, "Skipping deletion of the backup at " + shelvedProjectArchiveName);
                }
                Jenkins.getInstance().reload();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not unarchive project archive [" + shelvedProjectArchiveName + "].", e);
            }
        }
    }

    private boolean explode(File shelvedProjectArchive) throws IOException, InterruptedException {
        File rootDir = Jenkins.getInstance().getRootDir();
        Properties metadata = ShelvedProject.loadMetadata(shelvedProjectArchive);
        String projectPathProperty = metadata.getProperty("project.path");
        Path projectPath = rootDir.toPath().resolve("jobs").resolve(projectPathProperty);
        boolean isCompressedArchive = Boolean.parseBoolean(metadata.getProperty("archive.compression", "false"));
        if (Files.exists(projectPath, new LinkOption[0])) {
            LOGGER.log(Level.INFO, "A project exist for the given path " + projectPathProperty + "...skipping");
            return false;
        }
        new FilePath(shelvedProjectArchive).untar(new FilePath(new File(rootDir, "jobs")), isCompressedArchive ? FilePath.TarCompression.GZIP : FilePath.TarCompression.NONE);
        return true;
    }

    private void legacyExplode(File shelvedProjectArchive) throws IOException, InterruptedException {
        new FilePath(shelvedProjectArchive).unzip(new FilePath(new File(Jenkins.getInstance().getRootDir(), "jobs")));
    }

    public long getEstimatedDuration() {
        return -1L;
    }

    public String toString() {
        return "Unshelving Project";
    }
}

