/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.model.Queue;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.shelveproject.ShelvedProject;

public class DeleteProjectExecutable
implements Queue.Executable {
    private static final Logger LOGGER = Logger.getLogger(DeleteProjectExecutable.class.getName());
    private final String[] shelvedProjectArchiveNames;
    private final Queue.Task parentTask;

    public DeleteProjectExecutable(Queue.Task parentTask, String[] shelvedProjectArchiveNames) {
        this.parentTask = parentTask;
        this.shelvedProjectArchiveNames = shelvedProjectArchiveNames != null ? Arrays.copyOf(shelvedProjectArchiveNames, shelvedProjectArchiveNames.length) : null;
    }

    public Queue.Task getParent() {
        return this.parentTask;
    }

    public void run() {
        for (String shelvedProjectArchiveName : this.shelvedProjectArchiveNames) {
            File shelvedProjectArchive = DeleteProjectExecutable.getArchiveFile(shelvedProjectArchiveName);
            LOGGER.info("Deleting project [" + shelvedProjectArchiveName + "].");
            try {
                if ("tar".equals(FilenameUtils.getExtension((String)shelvedProjectArchiveName))) {
                    Files.delete(ShelvedProject.getMetadataFileFromArchive(shelvedProjectArchive));
                }
                Files.delete(shelvedProjectArchive.toPath());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not delete project archive [" + shelvedProjectArchiveName + "].", e);
            }
        }
    }

    static File getArchiveFile(String shelvedProjectArchiveName) {
        File shelvedProjectsDirectory = new File(Jenkins.getInstance().getRootDir(), "shelvedProjects");
        Collection files = FileUtils.listFiles((File)shelvedProjectsDirectory, null, (boolean)false);
        for (File file : files) {
            if (!StringUtils.equals((String)file.getName(), (String)shelvedProjectArchiveName)) continue;
            return file;
        }
        return null;
    }

    public long getEstimatedDuration() {
        return -1L;
    }

    public String toString() {
        return "Deleting Project";
    }
}

