/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Queue;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.shelveproject.DeleteProjectTask;
import org.jvnet.hudson.plugins.shelveproject.ShelvedProject;
import org.jvnet.hudson.plugins.shelveproject.UnshelveProjectTask;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
@Extension
public class ShelvedProjectsAction
implements RootAction {
    static final Logger LOGGER = Logger.getLogger(ShelvedProjectsAction.class.getName());

    public String getIconFileName() {
        if (Hudson.getInstance().hasPermission(Permission.CREATE)) {
            return "/plugin/shelve-project-plugin/icons/shelve-project-icon.png";
        }
        return null;
    }

    public String getDisplayName() {
        return "Shelved Projects";
    }

    public String getUrlName() {
        return "/shelvedProjects";
    }

    @Exported
    public List<ShelvedProject> getShelvedProjects() {
        Hudson.getInstance().checkPermission(Permission.CREATE);
        File shelvedProjectsDir = new File(Hudson.getInstance().getRootDir(), "shelvedProjects");
        shelvedProjectsDir.mkdirs();
        Collection shelvedProjectsArchives = FileUtils.listFiles((File)shelvedProjectsDir, (String[])new String[]{"zip"}, (boolean)false);
        LinkedList<ShelvedProject> projects = new LinkedList<ShelvedProject>();
        for (File archive : shelvedProjectsArchives) {
            projects.add(this.getShelvedProjectFromArchive(archive));
        }
        this.sortProjectsAlphabetically(projects);
        return projects;
    }

    private void sortProjectsAlphabetically(List<ShelvedProject> projects) {
        final Collator collator = Collator.getInstance();
        Collections.sort(projects, new Comparator<ShelvedProject>(){

            @Override
            public int compare(ShelvedProject project1, ShelvedProject project2) {
                return collator.compare(project1.getProjectName(), project2.getProjectName());
            }
        });
    }

    private ShelvedProject getShelvedProjectFromArchive(File archive) {
        ShelvedProject shelvedProject = new ShelvedProject();
        shelvedProject.setProjectName(StringUtils.substringBeforeLast((String)archive.getName(), (String)"-"));
        shelvedProject.setTimestamp(Long.valueOf(StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)archive.getName(), (String)"-"), (String)".")));
        shelvedProject.setArchive(archive);
        shelvedProject.setFormatedDate(this.formatDate(shelvedProject.getTimestamp()));
        return shelvedProject;
    }

    public HttpResponse doManageShelvedProject(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        if (request.hasParameter("unshelve")) {
            return this.unshelveProject(request);
        }
        if (request.hasParameter("delete")) {
            return this.deleteProject(request);
        }
        return this.createRedirectToShelvedProjectsPage();
    }

    private HttpResponse unshelveProject(StaplerRequest request) {
        Hudson.getInstance().checkPermission(Permission.CREATE);
        String[] archives = request.getParameterValues("archives");
        if (archives == null) {
            return this.createRedirectToShelvedProjectsPage();
        }
        LOGGER.info("Unshelving archived projects.");
        Hudson.getInstance().getQueue().schedule((Queue.Task)new UnshelveProjectTask(archives), 0);
        return this.createRedirectToMainPage();
    }

    private HttpResponse deleteProject(StaplerRequest request) {
        Hudson.getInstance().checkPermission(Permission.DELETE);
        String[] archives = request.getParameterValues("archives");
        if (archives == null) {
            return this.createRedirectToShelvedProjectsPage();
        }
        LOGGER.info("Deleting archived projects.");
        Hudson.getInstance().getQueue().schedule((Queue.Task)new DeleteProjectTask(archives), 0);
        return this.createRedirectToShelvedProjectsPage();
    }

    public String formatDate(long timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        return simpleDateFormat.format(new Date(timestamp));
    }

    private HttpResponse createRedirectToShelvedProjectsPage() {
        return new HttpRedirect(Hudson.getInstance().getRootUrl() + this.getUrlName());
    }

    private HttpRedirect createRedirectToMainPage() {
        return new HttpRedirect(Hudson.getInstance().getRootUrl());
    }
}

