/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.model.Hudson;
import hudson.model.Queue;
import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class DeleteProjectExecutable
implements Queue.Executable {
    private static final Logger LOGGER = Logger.getLogger(DeleteProjectExecutable.class.getName());
    private final String[] shelvedProjectArchiveNames;
    private final Queue.Task parentTask;

    public DeleteProjectExecutable(Queue.Task parentTask, String[] shelvedProjectArchiveNames) {
        this.parentTask = parentTask;
        this.shelvedProjectArchiveNames = shelvedProjectArchiveNames;
    }

    public Queue.Task getParent() {
        return this.parentTask;
    }

    public void run() {
        for (String shelvedProjectArchiveName : this.shelvedProjectArchiveNames) {
            File shelvedProjectArchive = this.getArchiveFile(shelvedProjectArchiveName);
            LOGGER.info("Deleting project [" + shelvedProjectArchiveName + "].");
            try {
                shelvedProjectArchive.delete();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not delete project archive [" + shelvedProjectArchiveName + "].", e);
            }
        }
    }

    private File getArchiveFile(String shelvedProjectArchiveName) {
        File shelvedProjectsDirectory = new File(Hudson.getInstance().getRootDir(), "shelvedProjects");
        Collection files = FileUtils.listFiles((File)shelvedProjectsDirectory, null, (boolean)false);
        for (File file : files) {
            if (!StringUtils.equals((String)file.getName(), (String)shelvedProjectArchiveName)) continue;
            return file;
        }
        return null;
    }

    public long getEstimatedDuration() {
        return -1L;
    }

    public String toString() {
        return "Deleting Project";
    }
}

