/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects.service;

import hudson.model.Hudson;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectManagement;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;

public class SharedObjectDataStore {
    public void writeSharedObjectsFile(SharedObjectType[] types) throws SharedObjectException {
        XStream2 xStream2 = new XStream2();
        File sharedObjectFileDir = Hudson.getInstance().getRootDir();
        sharedObjectFileDir.mkdirs();
        File sharedObjectsFile = new File(sharedObjectFileDir, "sharedObjects.xml");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(sharedObjectsFile, false);
            xStream2.toXML((Object)new SharedObjectManagement(types), (Writer)fileWriter);
        }
        catch (IOException e) {
            throw new SharedObjectException(e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    throw new SharedObjectException(e);
                }
            }
        }
    }

    public SharedObjectType[] readSharedObjectsFile() throws SharedObjectException {
        XStream2 xStream2 = new XStream2();
        File sharedObjectsFile = new File(Hudson.getInstance().getRootDir(), "sharedObjects.xml");
        if (sharedObjectsFile.exists()) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(sharedObjectsFile);
                if (sharedObjectsFile.exists()) {
                    SharedObjectManagement sharedObjectsManagement = (SharedObjectManagement)((Object)xStream2.fromXML((Reader)fileReader));
                    SharedObjectType[] sharedObjectTypeArray = sharedObjectsManagement.getTypes();
                    return sharedObjectTypeArray;
                }
            }
            catch (FileNotFoundException e) {
                throw new SharedObjectException(e);
            }
            catch (IOException e) {
                throw new SharedObjectException(e);
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        throw new SharedObjectException(e);
                    }
                }
            }
        }
        return new SharedObjectType[0];
    }
}

