/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects;

import hudson.DescriptorExtensionList;
import hudson.Functions;
import hudson.model.Hudson;
import hudson.security.Permission;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectDataStore;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SharedObjectManagementResult {
    private SharedObjectType[] types;

    public SharedObjectManagementResult(SharedObjectType[] types) {
        this.types = types;
    }

    public SharedObjectType[] getTypes() {
        return this.types;
    }

    public DescriptorExtensionList getListSharedObjectsDescriptors() {
        return DescriptorExtensionList.createDescriptorList((Hudson)Hudson.getInstance(), SharedObjectType.class);
    }

    public void doSaveConfig(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        JSONArray typesJSON;
        Functions.checkPermission((Permission)Hudson.ADMINISTER);
        JSONObject submittedForm = req.getSubmittedForm();
        try {
            typesJSON = submittedForm.getJSONArray("types");
        }
        catch (JSONException jsone) {
            typesJSON = submittedForm.getJSONObject("types");
        }
        List types = req.bindJSONToList(SharedObjectType.class, (Object)typesJSON);
        SharedObjectType[] typesArray = types.toArray(new SharedObjectType[types.size()]);
        SharedObjectDataStore store = new SharedObjectDataStore();
        try {
            store.writeSharedObjectsFile(typesArray);
        }
        catch (SharedObjectException e) {
            e.printStackTrace();
        }
        rsp.sendRedirect2("../manage");
    }
}

