/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects;

import hudson.Extension;
import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.jenkinsci.plugins.sharedobjects.SharedObjectsException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectsType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectsDataStore;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectsJobProperty
extends EnvInjectJobPropertyContributor {
    private boolean populateSharedObjects;

    public SharedObjectsJobProperty() {
    }

    @DataBoundConstructor
    public SharedObjectsJobProperty(boolean populateSharedObjects) {
        this.populateSharedObjects = populateSharedObjects;
    }

    public boolean getPopulateSharedObjects() {
        return this.populateSharedObjects;
    }

    public void init() {
        this.populateSharedObjects = true;
    }

    public Map<String, String> getEnvVars(TaskListener listener) throws EnvInjectException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.populateSharedObjects) {
            SharedObjectsDataStore dataStore = new SharedObjectsDataStore();
            try {
                SharedObjectsType[] sharedObjectsTypes;
                for (SharedObjectsType type : sharedObjectsTypes = dataStore.readSharedObjectsFile()) {
                    result.put(type.getName(), type.getEnvVarValue());
                }
            }
            catch (SharedObjectsException se) {
                throw new EnvInjectException((Throwable)se);
            }
        }
        return result;
    }

    @Extension
    public static class SharedObjectJobPropertyDescriptor
    extends EnvInjectJobPropertyContributorDescriptor {
        public String getDisplayName() {
            return "Populate Shared Objects";
        }
    }
}

