/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning.parsing;

import hudson.FilePath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.SemanticVersioning.AppVersion;
import org.jenkinsci.plugins.SemanticVersioning.InvalidBuildFileFormatException;
import org.jenkinsci.plugins.SemanticVersioning.parsing.AbstractBuildDefinitionParser;

public abstract class JsonVersionParser
extends AbstractBuildDefinitionParser {
    private final String filepath;
    private final String jsonpathVersion;

    protected JsonVersionParser(String filepath, String jsonpathVersion) {
        this.filepath = filepath;
        this.jsonpathVersion = jsonpathVersion;
    }

    @Override
    public AppVersion extractAppVersion(FilePath workspace, PrintStream logger) throws IOException, InvalidBuildFileFormatException {
        File file = new File(workspace.getRemote() + "/" + this.filepath);
        logger.println("looking for json file: " + file.getAbsolutePath() + " (" + file.exists() + ")");
        if (file.exists()) {
            String content = FileUtils.readFileToString((File)file);
            if (content == null || content.isEmpty()) {
                throw new InvalidBuildFileFormatException("ERROR: '" + this.filepath + "' is not a valid file.");
            }
            JSONObject out = JSONObject.fromObject((Object)content);
            String version = null;
            logger.println("looking for json elements ... ");
            for (String s : this.jsonpathVersion.split("\\.")) {
                Object o = out.get(s);
                logger.println(" - " + s + " = " + o);
                version = o.toString();
                if (!(o instanceof JSONObject)) break;
                out = (JSONObject)o;
            }
            logger.println("returning version: " + version);
            return AppVersion.parse(version);
        }
        logger.println("ERROR: file '" + file.getAbsolutePath() + "' does not exist!");
        throw new FileNotFoundException("'" + this.filepath + "' was not found.");
    }
}

