/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.SemanticVersioning;

import java.io.Serializable;

public class AppVersion
implements Serializable {
    private static final String SNAPSHOT = "SNAPSHOT";
    private final int major;
    private final int minor;
    private final String original;
    private int build;
    private final boolean isSnapshot;
    public static final AppVersion EmptyVersion = new AppVersion(0, 0, 0, false, "");

    public static AppVersion parse(String versionString) {
        String[] parts = versionString.split("[\\.-]");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int build = -1;
        boolean isSnapshot = false;
        if (parts.length == 3) {
            if (parts[2].equals(SNAPSHOT)) {
                isSnapshot = true;
            } else {
                build = Integer.parseInt(parts[2]);
            }
        } else if (parts.length == 4) {
            build = Integer.parseInt(parts[2]);
            isSnapshot = parts[3].equals(SNAPSHOT);
        }
        return new AppVersion(major, minor, build, isSnapshot, versionString);
    }

    private AppVersion(int major, int minor, int build, boolean isSnapshot, String original) {
        this.major = major;
        this.minor = minor;
        this.isSnapshot = isSnapshot;
        this.build = build;
        this.original = original;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public void setBuild(int build) {
        this.build = build;
    }

    public int getBuild() {
        return this.build;
    }

    public String toJsonString() {
        return String.format("{ \"major\": %d, \"minor\": %d, \"build\": %d, \"isSnapshot\": %b, \"originalString\": \"%s\" }", this.major, this.minor, this.build, this.isSnapshot, this.original);
    }

    public String toString() {
        String version = String.format("%s.%s", this.major, this.minor);
        if (this.build > -1) {
            version = version + "." + this.build;
        }
        if (this.isSnapshot) {
            version = version + "-SNAPSHOT";
        }
        return version;
    }
}

