/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.global;

import hudson.DescriptorExtensionList;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.TaskListener;
import hudson.plugins.selenium.PluginImpl;
import hudson.plugins.selenium.configuration.ConfigurationDescriptor;
import hudson.plugins.selenium.configuration.SeleniumNodeConfiguration;
import hudson.plugins.selenium.configuration.global.matcher.SeleniumConfigurationMatcher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SeleniumGlobalConfiguration
implements Serializable,
Describable<SeleniumGlobalConfiguration> {
    private static final long serialVersionUID = -8366478398033252973L;
    private String name;
    private SeleniumConfigurationMatcher matcher;
    private SeleniumNodeConfiguration configuration;

    @DataBoundConstructor
    public SeleniumGlobalConfiguration(String name, SeleniumConfigurationMatcher matcher, SeleniumNodeConfiguration configuration) {
        this.name = name;
        this.matcher = matcher;
        this.configuration = configuration;
    }

    public void start(Computer computer, TaskListener listener) throws IOException, InterruptedException, ExecutionException {
        if (this.matcher != null && this.matcher.match(computer.getNode())) {
            this.configuration.start(computer, listener, this.name);
        }
    }

    public void stop(Computer computer) {
        if (this.matcher != null && this.matcher.match(computer.getNode())) {
            this.configuration.stop(computer, this.name);
        }
    }

    public void remove(Computer computer) {
        PluginImpl.getPlugin().validateAdmin();
        this.configuration.remove(computer, this.name);
    }

    @Exported
    public String getName() {
        return this.name;
    }

    public String getMatcherSummary() {
        return this.matcher.getSummary();
    }

    @Exported
    public SeleniumConfigurationMatcher getMatcher() {
        return this.matcher;
    }

    @Exported
    public SeleniumNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getDisplayName() {
        return this.configuration.getDescriptor().getDisplayName();
    }

    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws Exception {
        PluginImpl.getPlugin().validateAdmin();
        PluginImpl.getPlugin().removeGlobalConfigurations(this.name);
        rsp.sendRedirect("../../configurations");
    }

    public Descriptor<SeleniumGlobalConfiguration> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public void doCommitEdit(StaplerRequest req, StaplerResponse rsp) throws Exception {
        PluginImpl.getPlugin().validateAdmin();
        SeleniumGlobalConfiguration conf = (SeleniumGlobalConfiguration)req.bindJSON(SeleniumGlobalConfiguration.class, req.getSubmittedForm());
        if (null == conf.getName() || conf.getName().trim().equals("")) {
            throw new Failure("You must specify a name for the configuration");
        }
        PluginImpl.getPlugin().replaceGlobalConfigurations(this.name, conf);
        rsp.sendRedirect2("../../configuration/" + conf.getName());
    }

    public DescriptorExtensionList<SeleniumNodeConfiguration, ConfigurationDescriptor> getConfigTypes() {
        return SeleniumNodeConfiguration.all();
    }

    public DescriptorExtensionList<SeleniumConfigurationMatcher, SeleniumConfigurationMatcher.MatcherDescriptor> getMatcherTypes() {
        return SeleniumConfigurationMatcher.all();
    }

    public static final class DescriptorImpl
    extends Descriptor<SeleniumGlobalConfiguration> {
        public String getDisplayName() {
            return null;
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            return FormValidation.validateRequired((String)name);
        }
    }
}

