/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser.webdriver;

import hudson.Extension;
import hudson.model.Computer;
import hudson.plugins.selenium.configuration.browser.EdgeDriverServerUtils;
import hudson.plugins.selenium.configuration.browser.webdriver.DriverRequiredWebDriverBrowser;
import hudson.plugins.selenium.configuration.browser.webdriver.WebDriverBrowser;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class EdgeBrowser
extends DriverRequiredWebDriverBrowser {
    private static final long serialVersionUID = 4134783568959523121L;
    private final transient String edgeDriverProperty = "webdriver.edge.driver";
    @Deprecated
    private transient String server_binary;

    @DataBoundConstructor
    public EdgeBrowser(int maxInstances, String version, String driverBinaryPath) {
        super(maxInstances, version, "MicrosoftEdge", driverBinaryPath);
    }

    @Override
    public Map<String, String> getJVMArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        EdgeBrowser.combine(args, "webdriver.edge.driver", this.getDriverBinaryPath());
        return args;
    }

    @Override
    public void initOptions(Computer c, SeleniumRunOptions opt) {
        String driverPath = EdgeDriverServerUtils.uploadEdgeDriverIfNecessary(c, this.getDriverBinaryPath());
        if (driverPath != null) {
            opt.getJVMArguments().put("webdriver.edge.driver", driverPath);
        }
        opt.addOptionIfSet("-browser", StringUtils.join(this.initBrowserOptions(c, opt), (String)","));
    }

    @Deprecated
    public String getServer_binary() {
        return this.server_binary;
    }

    public Object readResolve() {
        if (this.server_binary != null) {
            this.setDriverBinaryPath(this.server_binary);
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends WebDriverBrowser.WebDriverBrowserDescriptor {
        @Override
        public int getMaxInstances() {
            return 1;
        }

        public String getDisplayName() {
            return "Microsoft Edge";
        }
    }
}

